/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.event;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.client.control.KeybindManager;
import com.github.lehjr.powersuits.client.gui.clickable.ClickableKeybinding;
import com.github.lehjr.powersuits.client.model.helper.MPSModelHelper;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public enum RenderEventHandler {
    INSTANCE;

    private static boolean ownFly;
    private final DrawableMuseRect frame = new DrawableMuseRect((double)MPSSettings.getHudKeybindX(), (double)MPSSettings.getHudKeybindY(), (double)(MPSSettings.getHudKeybindX() + 16.0f), (double)(MPSSettings.getHudKeybindY() + 16.0f), true, Colour.DARK_GREEN.withAlpha(0.2f), Colour.GREEN.withAlpha(0.2f));

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void preTextureStitch(TextureStitchEvent.Pre event) {
        MPSModelHelper.loadArmorModels(event, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Post event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPostRenderGameOverlayEvent(RenderGameOverlayEvent.Post e) {
        RenderGameOverlayEvent.ElementType elementType = e.getType();
        if (RenderGameOverlayEvent.ElementType.HOTBAR.equals((Object)elementType)) {
            this.drawKeybindToggles(e.getMatrixStack());
        }
    }

    @SubscribeEvent
    public void onPreRenderPlayer(RenderPlayerEvent.Pre event) {
        if (!event.getPlayer().field_71075_bZ.field_75100_b && !event.getPlayer().func_233570_aj_() && this.playerHasFlightOn(event.getPlayer())) {
            event.getPlayer().field_71075_bZ.field_75100_b = true;
            ownFly = true;
        }
    }

    private boolean playerHasFlightOn(PlayerEntity player) {
        return player.func_184582_a(EquipmentSlotType.HEAD).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iModularItem -> iModularItem instanceof IModularItem && ((IModularItem)iModularItem).isModuleOnline(MPSRegistryNames.FLIGHT_CONTROL_MODULE_REGNAME)).orElse(false) != false || player.func_184582_a(EquipmentSlotType.CHEST).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iModularItem -> iModularItem instanceof IModularItem && ((IModularItem)iModularItem).isModuleOnline(MPSRegistryNames.JETPACK_MODULE_REGNAME) || ((IModularItem)iModularItem).isModuleOnline(MPSRegistryNames.GLIDER_MODULE_REGNAME)).orElse(false) != false || player.func_184582_a(EquipmentSlotType.FEET).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iModularItem -> iModularItem instanceof IModularItem && ((IModularItem)iModularItem).isModuleOnline(MPSRegistryNames.JETBOOTS_MODULE_REGNAME)).orElse(false) != false;
    }

    @SubscribeEvent
    public void onPostRenderPlayer(RenderPlayerEvent.Post event) {
        if (ownFly) {
            ownFly = false;
            event.getPlayer().field_71075_bZ.field_75100_b = false;
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent e) {
        ItemStack helmet = e.getEntity().func_184582_a(EquipmentSlotType.HEAD);
        helmet.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            ItemStack binnoculars;
            if (h instanceof IModularItem && !(binnoculars = ((IModularItem)h).getOnlineModuleOrEmpty(MPSRegistryNames.BINOCULARS_MODULE_REGNAME)).func_190926_b()) {
                e.setNewfov((float)((double)e.getNewfov() / binnoculars.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.applyPropertyModifiers("fieldOfView")).orElse(1.0)));
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawKeybindToggles(MatrixStack matrixStack) {
        float zLevel;
        float f = zLevel = Minecraft.func_71410_x().field_71462_r != null ? (float)Minecraft.func_71410_x().field_71462_r.func_230927_p_() : 0.0f;
        if (MPSSettings.displayHud()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity player = minecraft.field_71439_g;
            this.frame.setLeft((double)MPSSettings.getHudKeybindX());
            this.frame.setTop((double)MPSSettings.getHudKeybindY());
            this.frame.setBottom(this.frame.top() + 16.0);
            for (ClickableKeybinding kb : KeybindManager.INSTANCE.getKeybindings()) {
                if (!kb.displayOnHUD) continue;
                float stringwidth = MuseRenderer.getFontRenderer().func_238414_a_((ITextProperties)kb.getLabel());
                this.frame.setWidth((double)(stringwidth + (float)(kb.getBoundModules().size() * 16)));
                this.frame.draw(matrixStack, zLevel);
                MuseRenderer.drawCenteredText((MatrixStack)matrixStack, (ITextComponent)kb.getLabel(), (float)((float)this.frame.left() + 1.0f), (float)((float)this.frame.top() + 3.0f), (Colour)(kb.toggleval ? Colour.RED : Colour.GREEN));
                double x = this.frame.left() + (double)stringwidth;
                for (ClickableModule module : kb.getBoundModules()) {
                    boolean active = false;
                    for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                        ItemStack stack = player.func_184582_a(slot);
                        active = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
                            if (iItemHandler instanceof IModularItem) {
                                return ((IModularItem)iItemHandler).isModuleOnline(module.getModule().func_77973_b().getRegistryName());
                            }
                            return false;
                        }).orElse(false);
                    }
                    MuseRenderer.drawModuleAt((MatrixStack)matrixStack, (double)x, (double)this.frame.top(), (ItemStack)module.getModule(), (boolean)active);
                    x += 16.0;
                }
                this.frame.setTop(this.frame.top() + 16.0);
                this.frame.setBottom(this.frame.top() + 16.0);
            }
        }
    }

    static {
        ownFly = false;
    }
}

