/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.clickable;

import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.network.packets.ToggleRequestPacket;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableButton;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.github.lehjr.powersuits.client.control.KeybindManager;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class ClickableKeybinding
extends ClickableButton {
    public boolean toggleval = false;
    public boolean displayOnHUD;
    protected List<ClickableModule> boundModules = new ArrayList<ClickableModule>();
    boolean toggled = false;
    KeyBinding keybind;

    public ClickableKeybinding(KeyBinding keybind, MusePoint2D position, boolean free, Boolean displayOnHUD) {
        super(ClickableKeybinding.parseName(keybind), position, true);
        this.displayOnHUD = displayOnHUD != null ? displayOnHUD : false;
        this.keybind = keybind;
    }

    static ITextComponent parseName(KeyBinding keybind) {
        if (keybind.getKey().func_197937_c() < 0) {
            return new TranslationTextComponent("Mouse" + (keybind.getKey().func_197937_c() + 100));
        }
        return new TranslationTextComponent(keybind.getKey().func_197935_d());
    }

    public void doToggleTick() {
        this.doToggleIf(this.keybind.func_151468_f());
    }

    public void doToggleIf(boolean value) {
        if (value && !this.toggled) {
            this.toggleModules();
            KeybindManager.INSTANCE.writeOutKeybinds();
        }
        this.toggled = value;
    }

    public void toggleModules() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        for (ClickableModule module : this.boundModules) {
            ResourceLocation registryName = module.getModule().func_77973_b().getRegistryName();
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                player.field_71071_by.func_70301_a(i).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                    if (handler instanceof IModularItem) {
                        ((IModularItem)handler).toggleModule(registryName, this.toggleval);
                    }
                });
            }
            NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new ToggleRequestPacket(registryName, this.toggleval));
        }
        this.toggleval = !this.toggleval;
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
        super.render(matrixStack, mouseX, mouseY, partialTicks, zLevel);
        for (ClickableModule module : this.boundModules) {
            MuseRenderer.drawLineBetween((IClickable)this, (IClickable)module, (Colour)Colour.LIGHT_BLUE, (float)zLevel);
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)0.5, (double)0.5, (double)0.5);
            if (this.displayOnHUD) {
                MuseRenderer.drawString((MatrixStack)matrixStack, (String)MuseStringUtils.wrapFormatTags((String)"HUD", (MuseStringUtils.FormatCodes)MuseStringUtils.FormatCodes.BrightGreen), (double)(this.position.getX() * 2.0 + 6.0), (double)(this.position.getY() * 2.0 + 6.0));
            } else {
                MuseRenderer.drawString((MatrixStack)matrixStack, (String)MuseStringUtils.wrapFormatTags((String)"x", (MuseStringUtils.FormatCodes)MuseStringUtils.FormatCodes.Red), (double)(this.position.getX() * 2.0 + 6.0), (double)(this.position.getY() * 2.0 + 6.0));
            }
            RenderSystem.popMatrix();
        }
    }

    public KeyBinding getKeyBinding() {
        return this.keybind;
    }

    public List<ClickableModule> getBoundModules() {
        return this.boundModules;
    }

    public void bindModule(ClickableModule module) {
        if (!this.boundModules.contains(module)) {
            this.boundModules.add(module);
        }
    }

    public void unbindModule(ClickableModule module) {
        this.boundModules.remove(module);
    }

    public void unbindFarModules() {
        Iterator<ClickableModule> iterator = this.boundModules.iterator();
        while (iterator.hasNext()) {
            ClickableModule module = iterator.next();
            int maxDistance = this.getTargetDistance() * 2;
            double distanceSq = module.getPosition().distanceSq(this.getPosition());
            if (!(distanceSq > (double)(maxDistance * maxDistance))) continue;
            iterator.remove();
        }
    }

    public int getTargetDistance() {
        return this.boundModules.size() > 6 ? 16 + (this.boundModules.size() - 6) * 3 : 16;
    }

    public void attractBoundModules(IClickable exception) {
        for (ClickableModule module : this.boundModules) {
            if (module.equals(exception)) continue;
            MusePoint2D euclideanDistance = module.getPosition().minus(this.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times((double)this.getTargetDistance()).plus(this.getPosition());
            MusePoint2D midpointTangent = module.getPosition().midpoint(tangentTarget);
            module.setPosition(midpointTangent.copy());
        }
    }

    public boolean equals(ClickableKeybinding other) {
        return other.keybind.getKey().func_197937_c() == this.keybind.getKey().func_197937_c();
    }

    public void toggleHUDState() {
        this.displayOnHUD = !this.displayOnHUD;
    }
}

