/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.common;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableItem;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.FlyFromPointToPoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.client.sound.Musique;
import com.github.lehjr.numina.util.client.sound.SoundDictionary;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.github.lehjr.powersuits.container.MPSWorkbenchContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemSelectionFrame
extends ScrollableFrame {
    protected ArrayList<ClickableItem> itemButtons = new ArrayList();
    protected int selectedItemStack = -1;
    protected PlayerEntity player;
    protected int lastItemSlot = -1;
    protected List<MusePoint2D> itemPoints;
    protected List<Integer> indices;
    MPSWorkbenchContainer container;
    OnSelectNewItem doThis;

    public ItemSelectionFrame(@Nullable MPSWorkbenchContainer container, MusePoint2D topleft, MusePoint2D bottomright, float zLevel, Colour borderColour, Colour insideColour, PlayerEntity player) {
        super(topleft, bottomright, zLevel, borderColour, insideColour);
        this.container = container;
        this.player = player;
        if (container != null) {
            this.loadPoints(container.getModularItemToSlotMap().keySet().size());
        } else {
            this.loadIndices();
            if (this.indices != null && !this.indices.isEmpty()) {
                this.loadPoints(this.indices.size());
                this.loadItems();
            }
        }
    }

    public void init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
        if (this.container != null) {
            this.loadPoints(this.container.getModularItemToSlotMap().keySet().size());
        } else {
            this.loadIndices();
            if (this.indices != null && !this.indices.isEmpty()) {
                this.loadPoints(this.indices.size());
                this.loadItems();
            }
        }
    }

    public int getLastItemSlot() {
        return this.lastItemSlot;
    }

    public int getSelectedItemSlot() {
        return this.selectedItemStack;
    }

    private void loadPoints(int num) {
        double centerx = (this.border.left() + this.border.right()) / 2.0;
        double centery = (this.border.top() + this.border.bottom()) / 2.0;
        this.itemPoints = new ArrayList<MusePoint2D>();
        List targetPoints = GradientAndArcCalculator.pointsInLine((int)num, (MusePoint2D)new MusePoint2D(centerx, this.border.top()), (MusePoint2D)new MusePoint2D(centerx, this.border.bottom()), (double)0.0, (double)18.0);
        for (MusePoint2D point : targetPoints) {
            this.itemPoints.add((MusePoint2D)new FlyFromPointToPoint2D(new MusePoint2D(centerx, centery), point, 200.0));
        }
        this.totalsize = (targetPoints.size() + 1) * 18;
    }

    private void loadIndices() {
        this.indices = new ArrayList<Integer>();
        for (int index = 0; index < this.player.field_71071_by.func_70302_i_(); ++index) {
            if (index <= 35 && this.player.field_71071_by.field_70461_c != index || !this.player.field_71071_by.func_70301_a(index).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(m -> m instanceof IModularItem).orElse(false).booleanValue()) continue;
            this.indices.add(index);
        }
    }

    private void loadItems() {
        block3: {
            block2: {
                if (this.container == null) break block2;
                this.itemButtons = new ArrayList();
                Iterator<MusePoint2D> pointiterator = this.itemPoints.iterator();
                for (Integer slotIndex : this.container.getModularItemToSlotMap().keySet()) {
                    Slot slot = this.container.func_75139_a(slotIndex);
                    int index = slot.getSlotIndex();
                    ClickableItem button = new ClickableItem(pointiterator.next(), index);
                    button.containerIndex = slotIndex;
                    this.itemButtons.add(button);
                }
                break block3;
            }
            if (this.indices == null || this.indices.isEmpty()) break block3;
            this.itemButtons = new ArrayList();
            Iterator<MusePoint2D> pointiterator = this.itemPoints.iterator();
            for (Integer index : this.indices) {
                this.itemButtons.add(new ClickableItem(pointiterator.next(), index.intValue()));
            }
        }
    }

    public void update(double mousex, double mousey) {
        this.loadItems();
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.currentscrollpixels = Math.min(this.currentscrollpixels, this.getMaxScrollPixels());
        super.preRender(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)(-this.currentscrollpixels), 0.0);
        this.drawItems(matrixStack, mouseX, mouseY, partialTicks);
        this.drawSelection(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.func_227865_b_();
        super.postRender(mouseX, mouseY, partialTicks);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        if (this.border.containsPoint(mouseX, mouseY)) {
            this.currentscrollpixels = (int)((double)this.currentscrollpixels - dWheel * this.getScrollAmount());
            this.currentscrollpixels = (int)MuseMathUtils.clampDouble((double)this.currentscrollpixels, (double)0.0, (double)this.getMaxScrollPixels());
            return true;
        }
        return false;
    }

    private void drawItems(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (ClickableItem item : this.itemButtons) {
            item.render(matrixStack, mouseX, mouseY, partialTicks, this.zLevel);
        }
    }

    private void drawSelection(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        MusePoint2D pos;
        if (this.selectedItemStack != -1 && (pos = this.itemButtons.get(this.selectedItemStack).getPosition()).getY() > (double)this.currentscrollpixels + this.border.top() + 4.0 && pos.getY() < (double)this.currentscrollpixels + this.border.top() + this.border.height() - 4.0) {
            MuseRenderer.drawCircleAround((MatrixStack)matrixStack, (double)pos.getX(), (double)pos.getY(), (double)10.0, (float)this.getzLevel());
        }
    }

    public boolean hasNoItems() {
        return this.itemButtons.size() == 0;
    }

    public ClickableItem getPreviousSelectedItem() {
        if (this.itemButtons.size() > this.lastItemSlot && this.lastItemSlot != -1) {
            return this.itemButtons.get(this.lastItemSlot);
        }
        return null;
    }

    public ClickableItem getSelectedItem() {
        if (this.itemButtons.size() > this.selectedItemStack && this.selectedItemStack != -1) {
            return this.itemButtons.get(this.selectedItemStack);
        }
        return null;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (super.mouseClicked(x, y, button)) {
            return true;
        }
        if (this.border.containsPoint(x, y)) {
            y += (double)this.currentscrollpixels;
            int i = 0;
            for (ClickableItem item : this.itemButtons) {
                if (item.hitBox(x, y)) {
                    this.lastItemSlot = this.selectedItemStack;
                    Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_SELECT, (float)1.0f);
                    this.selectedItemStack = i;
                    if (this.getSelectedItem() != this.getPreviousSelectedItem()) {
                        this.onSelected();
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.border.containsPoint((double)x, (double)y)) {
            y += this.currentscrollpixels;
            if (this.itemButtons != null) {
                for (ClickableItem item : this.itemButtons) {
                    if (!item.hitBox((double)x, (double)y)) continue;
                    return item.getToolTip();
                }
            }
        }
        return null;
    }

    public void setDoOnNewSelect(OnSelectNewItem doThisIn) {
        this.doThis = doThisIn;
    }

    void onSelected() {
        if (this.doThis != null) {
            this.doThis.onSelected(this);
        }
    }

    public static interface OnSelectNewItem {
        public void onSelected(ItemSelectionFrame var1);
    }
}

