/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.keybind;

import com.github.lehjr.numina.client.control.KeyBindingHelper;
import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableButton;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.clickable.IClickable;
import com.github.lehjr.numina.util.client.gui.frame.IGuiFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.GradientAndArcCalculator;
import com.github.lehjr.numina.util.client.gui.gemoetry.IRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.client.control.KeybindManager;
import com.github.lehjr.powersuits.client.gui.clickable.ClickableKeybinding;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class KeybindConfigFrame
implements IGuiFrame {
    private static KeyBindingHelper keyBindingHelper = new KeyBindingHelper();
    protected Set<ClickableModule> modules;
    protected IClickable selectedClickie;
    protected ClickableKeybinding closestKeybind;
    protected PlayerEntity player;
    protected boolean selecting;
    protected ClickableButton newKeybindButton;
    protected ClickableButton trashKeybindButton;
    protected long takenTime;
    KeybindManager keybindManager = KeybindManager.INSTANCE;
    MuseRect rect;
    boolean enabled = true;
    boolean visible = true;

    public KeybindConfigFrame(MuseRect backgroundRect, PlayerEntity player) {
        this.modules = new HashSet<ClickableModule>();
        for (ClickableKeybinding kb : this.keybindManager.getKeybindings()) {
            this.modules.addAll(kb.getBoundModules());
        }
        this.rect = backgroundRect;
        this.player = player;
        MusePoint2D center = this.rect.center();
        this.newKeybindButton = new ClickableButton((ITextComponent)new TranslationTextComponent("gui.powersuits.newKeybind"), center.plus(new MusePoint2D(0.0, -8.0)), true);
        this.trashKeybindButton = new ClickableButton((ITextComponent)new TranslationTextComponent("gui.powersuits.trashKeybind"), center.plus(new MusePoint2D(0.0, 8.0)), true);
    }

    public void init(double left, double top, double right, double bottom) {
        this.newKeybindButton.setPosition(this.rect.center().plus(new MusePoint2D(0.0, -8.0)));
        this.trashKeybindButton.setPosition(this.rect.center().plus(new MusePoint2D(0.0, 8.0)));
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.rect.containsPoint(x, y)) {
            if (button == 0) {
                if (this.selectedClickie == null) {
                    for (ClickableModule module : this.modules) {
                        if (!module.hitBox(x, y)) continue;
                        this.selectedClickie = module;
                        return true;
                    }
                    for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
                        if (!keybind.hitBox(x, y)) continue;
                        this.selectedClickie = keybind;
                        return true;
                    }
                }
                if (this.newKeybindButton.hitBox(x, y)) {
                    this.selecting = true;
                }
            } else if (button == 1) {
                for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
                    if (!keybind.hitBox(x, y)) continue;
                    keybind.toggleHUDState();
                    return true;
                }
            } else if (button > 2) {
                int key = button - 100;
                if (keyBindingHelper.keyBindingHasKey(key)) {
                    this.takenTime = System.currentTimeMillis();
                }
                if (!keyBindingHelper.keyBindingHasKey(key)) {
                    this.addKeybind(key, true);
                } else if (MPSSettings.allowConfictingKeyBinds()) {
                    this.addKeybind(key, false);
                }
                this.selecting = false;
            }
            return true;
        }
        return false;
    }

    public void refreshModules() {
        NonNullList installedModules = NonNullList.func_191196_a();
        block4: for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            switch (slot.func_188453_a()) {
                case HAND: {
                    this.player.func_184582_a(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iModeChanging -> {
                        if (iModeChanging instanceof IModeChangingItem) {
                            installedModules.addAll((Collection)((IModularItem)iModeChanging).getInstalledModulesOfType(IToggleableModule.class));
                        }
                    });
                    continue block4;
                }
                case ARMOR: {
                    if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue block4;
                    this.player.func_184582_a(slot).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iModularItem -> {
                        if (iModularItem instanceof IModularItem) {
                            installedModules.addAll((Collection)((IModularItem)iModularItem).getInstalledModulesOfType(IToggleableModule.class));
                        }
                    });
                }
            }
        }
        List points = GradientAndArcCalculator.pointsInLine((int)installedModules.size(), (MusePoint2D)new MusePoint2D(this.rect.finalLeft() + 10.0, this.rect.finalTop() + 10.0), (MusePoint2D)new MusePoint2D(this.rect.finalLeft() + 10.0, this.rect.finalBottom() - 10.0));
        Iterator pointIterator = points.iterator();
        for (ItemStack module : installedModules) {
            if (this.alreadyAdded(module)) continue;
            ClickableModule clickie = new ClickableModule(module, (MusePoint2D)pointIterator.next(), -1, EnumModuleCategory.NONE);
            this.modules.add(clickie);
        }
    }

    public boolean alreadyAdded(@Nonnull ItemStack module) {
        if (module.func_190926_b()) {
            return false;
        }
        for (ClickableModule clickie : this.modules) {
            if (!ItemStack.func_179545_c((ItemStack)clickie.getModule(), (ItemStack)module)) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (button == 0) {
            if (this.selectedClickie != null && this.closestKeybind != null && this.selectedClickie instanceof ClickableModule) {
                this.closestKeybind.bindModule((ClickableModule)this.selectedClickie);
            } else if (this.selectedClickie != null && this.selectedClickie instanceof ClickableKeybinding && this.trashKeybindButton.hitBox((double)((float)x), (double)((float)y))) {
                KeyBinding binding = ((ClickableKeybinding)this.selectedClickie).getKeyBinding();
                keyBindingHelper.removeKey(binding);
                keyBindingHelper.removeKey(binding);
                this.keybindManager.remove((ClickableKeybinding)this.selectedClickie);
            }
            this.selectedClickie = null;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double dWheel) {
        return false;
    }

    public void update(double mousex, double mousey) {
        if (this.selecting) {
            return;
        }
        this.refreshModules();
        this.closestKeybind = null;
        double closestDistance = Double.MAX_VALUE;
        if (this.selectedClickie != null) {
            this.selectedClickie.setPosition(new MusePoint2D(mousex, mousey));
            if (this.selectedClickie instanceof ClickableModule) {
                ClickableModule selectedModule = (ClickableModule)this.selectedClickie;
                for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
                    double distance = keybind.getPosition().minus(selectedModule.getPosition()).distance();
                    if (!(distance < closestDistance) || !((closestDistance = distance) < 32.0)) continue;
                    this.closestKeybind = keybind;
                }
            }
        }
        for (ClickableKeybinding clickableKeybinding : this.keybindManager.getKeybindings()) {
            if (clickableKeybinding != this.selectedClickie) {
                clickableKeybinding.unbindFarModules();
            }
            clickableKeybinding.attractBoundModules(this.selectedClickie);
        }
        for (IClickable iClickable : this.modules) {
            if (iClickable == this.selectedClickie) continue;
            this.repelOtherModules(iClickable);
        }
        for (IClickable iClickable : this.keybindManager.getKeybindings()) {
            if (iClickable == this.selectedClickie) continue;
            this.repelOtherModules(iClickable);
        }
        for (IClickable iClickable : this.modules) {
            this.clampClickiePosition(iClickable);
        }
        for (IClickable iClickable : this.keybindManager.getKeybindings()) {
            this.clampClickiePosition(iClickable);
        }
    }

    private void clampClickiePosition(IClickable clickie) {
        MusePoint2D position = clickie.getPosition();
        position.setX(this.clampDouble(position.getX(), this.rect.finalLeft(), this.rect.finalRight()));
        position.setY(this.clampDouble(position.getY(), this.rect.finalTop(), this.rect.finalBottom()));
    }

    private double clampDouble(double x, double lower, double upper) {
        if (x < lower) {
            return lower;
        }
        if (x > upper) {
            return upper;
        }
        return x;
    }

    private void repelOtherModules(IClickable module) {
        MusePoint2D modulePosition = module.getPosition();
        for (ClickableModule otherModule : this.modules) {
            if (otherModule == this.selectedClickie || otherModule == module || !(otherModule.getPosition().distanceTo(modulePosition) < 16.0)) continue;
            MusePoint2D euclideanDistance = otherModule.getPosition().minus(module.getPosition());
            MusePoint2D directionVector = euclideanDistance.normalize();
            MusePoint2D tangentTarget = directionVector.times(16.0).plus(module.getPosition());
            MusePoint2D midpointTangent = otherModule.getPosition().midpoint(tangentTarget);
            if (midpointTangent.distanceTo(module.getPosition()) > 2.0) {
                otherModule.setPosition(midpointTangent.copy());
            }
            MusePoint2D away = directionVector.times(0.0).plus(modulePosition);
            module.setPosition(away.copy());
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float zLevel = Minecraft.func_71410_x().field_71462_r.func_230927_p_();
        MusePoint2D center = this.rect.center();
        if (this.selecting) {
            MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.pressKey", (Object[])new Object[0]), (double)center.getX(), (double)center.getY());
            return;
        }
        this.newKeybindButton.render(matrixStack, mouseX, mouseY, partialTicks, zLevel);
        this.trashKeybindButton.render(matrixStack, mouseX, mouseY, partialTicks, zLevel);
        MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.keybindInstructions1", (Object[])new Object[0]), (double)center.getX(), (double)(center.getY() + 40.0));
        MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.keybindInstructions2", (Object[])new Object[0]), (double)center.getX(), (double)(center.getY() + 50.0));
        MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.keybindInstructions3", (Object[])new Object[0]), (double)center.getX(), (double)(center.getY() + 60.0));
        MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.keybindInstructions4", (Object[])new Object[0]), (double)center.getX(), (double)(center.getY() + 70.0));
        if (this.takenTime + 1000L > System.currentTimeMillis()) {
            MusePoint2D pos = this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0));
            MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.keybindTaken", (Object[])new Object[0]), (double)pos.getX(), (double)pos.getY());
        }
        for (ClickableModule module : this.modules) {
            module.render(matrixStack, mouseX, mouseY, partialTicks, zLevel);
        }
        for (ClickableKeybinding keybind : this.keybindManager.getKeybindings()) {
            keybind.render(matrixStack, mouseX, mouseY, partialTicks, zLevel);
        }
        if (this.selectedClickie != null && this.closestKeybind != null) {
            MuseRenderer.drawLineBetween((IClickable)this.selectedClickie, (IClickable)this.closestKeybind, (Colour)Colour.YELLOW, (float)zLevel);
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        for (ClickableModule module : this.modules) {
            if (!module.hitBox((double)x, (double)y)) continue;
            if (KeybindConfigFrame.doAdditionalInfo()) {
                return module.getToolTip();
            }
            return Collections.singletonList(module.getLocalizedName());
        }
        return null;
    }

    public static boolean doAdditionalInfo() {
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        int key = p_keyPressed_1_;
        if (this.selecting) {
            if (keyBindingHelper.keyBindingHasKey(key)) {
                this.takenTime = System.currentTimeMillis();
            }
            if (!keyBindingHelper.keyBindingHasKey(key)) {
                this.addKeybind(key, true);
            } else if (MPSSettings.allowConfictingKeyBinds()) {
                this.addKeybind(key, false);
            }
            this.selecting = false;
        }
        return true;
    }

    private void addKeybind(int key, boolean free) {
        this.addKeybind(KeyBindingHelper.getInputByCode((int)key), free);
    }

    private void addKeybind(InputMappings.Input key, boolean free) {
        String name;
        try {
            name = key.func_197935_d();
        }
        catch (Exception e) {
            name = "???";
        }
        KeyBinding keybind = new KeyBinding(name, key.func_197937_c(), "Modular Powersuits");
        ClickableKeybinding clickie = new ClickableKeybinding(keybind, this.newKeybindButton.getPosition().plus(new MusePoint2D(0.0, -20.0)), free, false);
        this.keybindManager.getKeybindings().add(clickie);
    }

    public IRect getBorder() {
        return this.rect;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public IRect setLeft(double v) {
        return this.rect.setLeft(v);
    }

    public IRect setRight(double v) {
        return this.rect.setRight(v);
    }

    public IRect setTop(double v) {
        return this.rect.setTop(v);
    }

    public IRect setBottom(double v) {
        return this.rect.setBottom(v);
    }

    public IRect setWidth(double v) {
        return this.rect.setWidth(v);
    }

    public IRect setHeight(double v) {
        return this.rect.setHeight(v);
    }
}

