/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.cosmetic;

import com.github.lehjr.numina.basemod.MuseLogger;
import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import com.github.lehjr.numina.util.client.gui.GuiIcon;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableLabel;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableSlider;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.DrawableMuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.client.render.MuseIconUtils;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.client.gui.common.ItemSelectionFrame;
import com.github.lehjr.powersuits.client.gui.obsolete.ScrollableLabel;
import com.github.lehjr.powersuits.client.gui.obsolete.ScrollableRectangle;
import com.github.lehjr.powersuits.client.gui.obsolete.ScrollableSlider;
import com.github.lehjr.powersuits.network.MPSPackets;
import com.github.lehjr.powersuits.network.packets.ColourInfoPacket;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ColourPickerFrame
extends ScrollableFrame {
    public ItemSelectionFrame itemSelector;
    public ScrollableSlider rslider;
    public ScrollableSlider gslider;
    public ScrollableSlider bslider;
    public ScrollableSlider aslider;
    ScrollableColourBox colourBox;
    String COLOUR_PREFIX = I18n.func_135052_a((String)"gui.powersuits.colourPrefix", (Object[])new Object[0]);
    public ScrollableLabel colourLabel;
    public ScrollableSlider selectedSlider;
    public int selectedColour;
    public int decrAbove;
    ScrollableRectangle[] rectangles;

    public ColourPickerFrame(MusePoint2D topleft, MusePoint2D bottomright, float zLevel, Colour borderColour, Colour insideColour, ItemSelectionFrame itemSelector) {
        super(topleft, bottomright, zLevel, borderColour, insideColour);
        this.itemSelector = itemSelector;
    }

    public void init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
        if (this.itemSelector.hasNoItems()) {
            this.disable();
        } else {
            this.enable();
        }
        this.rectangles = new ScrollableRectangle[6];
        this.totalsize = 120;
        this.rslider = this.getScrollableSlider("red", null, 0);
        this.gslider = this.getScrollableSlider("green", this.rslider, 1);
        this.bslider = this.getScrollableSlider("blue", this.gslider, 2);
        this.aslider = this.getScrollableSlider("alpha", this.bslider, 3);
        this.colourBox = new ScrollableColourBox(new MuseRelativeRect(this.border.left(), this.aslider.bottom(), this.border.right(), this.aslider.bottom() + 25.0));
        this.colourBox.setMeBelow((MuseRect)this.aslider);
        this.rectangles[4] = this.colourBox;
        MuseRelativeRect colourLabelBox = new MuseRelativeRect(this.border.left(), this.colourBox.bottom(), this.border.right(), this.colourBox.bottom() + 20.0);
        this.colourLabel = new ScrollableLabel(new ClickableLabel(this.COLOUR_PREFIX, new MusePoint2D(colourLabelBox.centerx(), colourLabelBox.centery())), colourLabelBox);
        this.colourLabel.setMeBelow((MuseRect)this.colourBox);
        this.rectangles[5] = this.colourLabel;
        this.selectedSlider = null;
        this.selectedColour = 0;
        this.decrAbove = -1;
    }

    public ScrollableSlider getScrollableSlider(String id, ScrollableRectangle prev, int index) {
        MuseRelativeRect newborder = new MuseRelativeRect(this.border.left(), prev != null ? prev.bottom() : this.border.top(), this.border.right(), (prev != null ? prev.bottom() : this.border.top()) + 18.0);
        ClickableSlider slider = new ClickableSlider(new MusePoint2D(newborder.centerx(), newborder.centery()), newborder.width() - 15.0, id, (ITextComponent)new TranslationTextComponent("module.tradeoff." + id));
        ScrollableSlider scrollableSlider = new ScrollableSlider(slider, newborder);
        scrollableSlider.setMeBelow((MuseRect)(prev != null ? prev : null));
        this.rectangles[index] = scrollableSlider;
        return scrollableSlider;
    }

    public int[] colours() {
        return this.getOrCreateColourTag() != null ? this.getOrCreateColourTag().func_150302_c() : new int[]{};
    }

    public IntArrayNBT getOrCreateColourTag() {
        if (this.itemSelector.getSelectedItem() == null) {
            return null;
        }
        return this.itemSelector.getSelectedItem().getStack().getCapability(ModelSpecNBTCapability.RENDER).map(spec -> {
            CompoundNBT renderSpec = spec.getRenderTag();
            if (renderSpec != null && !renderSpec.isEmpty()) {
                return new IntArrayNBT(spec.getColorArray());
            }
            return new IntArrayNBT(new int[0]);
        }).orElse(new IntArrayNBT(new int[0]));
    }

    public IntArrayNBT setColourTagMaybe(List<Integer> intList) {
        if (this.itemSelector.getSelectedItem() == null) {
            return null;
        }
        return this.itemSelector.getSelectedItem().getStack().getCapability(ModelSpecNBTCapability.RENDER).map(spec -> {
            CompoundNBT renderSpec = spec.getRenderTag();
            renderSpec.func_218657_a("colours", (INBT)new IntArrayNBT(intList));
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player.field_70170_p.field_72995_K) {
                MPSPackets.CHANNEL_INSTANCE.sendToServer((Object)new ColourInfoPacket(this.itemSelector.getSelectedItem().getSlotIndex(), this.colours()));
            }
            return (IntArrayNBT)renderSpec.func_74781_a("colours");
        }).orElse(new IntArrayNBT(new int[0]));
    }

    public boolean mouseReleased(double x, double y, int button) {
        if (this.isEnabled()) {
            this.selectedSlider = null;
        }
        return false;
    }

    public DrawableMuseRect getBorder() {
        return this.border;
    }

    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
        if (this.isEnabled()) {
            if (this.selectedSlider != null) {
                this.selectedSlider.getSlider().setValueByX(mousex);
                if (this.colours().length > this.selectedColour) {
                    this.colours()[this.selectedColour] = Colour.getInt((float)((float)this.rslider.getValue()), (float)((float)this.gslider.getValue()), (float)((float)this.bslider.getValue()), (float)((float)this.aslider.getValue()));
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player.field_70170_p.field_72995_K) {
                        MPSPackets.CHANNEL_INSTANCE.sendToServer((Object)new ColourInfoPacket(this.itemSelector.getSelectedItem().inventorySlot, this.colours()));
                    }
                }
            } else if (this.itemSelector.getSelectedItem() != null && this.colours().length > 0 && this.selectedColour <= this.colours().length - 1) {
                this.onSelectColour(this.selectedColour);
            }
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.currentscrollpixels = Math.min(this.currentscrollpixels, this.getMaxScrollPixels());
            if (this.colours().length > this.selectedColour) {
                this.colourLabel.setText(this.COLOUR_PREFIX + " 0X" + new Colour(this.colours()[this.selectedColour]).hexColour());
            }
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)(-this.currentscrollpixels), (float)0.0f);
            for (ScrollableRectangle f : this.rectangles) {
                f.render(matrixStack, mouseX, mouseY, partialTicks, this.zLevel);
            }
            RenderSystem.popMatrix();
            super.postRender(mouseX, mouseY, partialTicks);
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        return null;
    }

    public void onSelectColour(int i) {
        Colour c = new Colour(this.colours()[i]);
        this.rslider.setValue(c.r);
        this.gslider.setValue(c.g);
        this.bslider.setValue(c.b);
        this.aslider.setValue(c.a);
        this.selectedColour = i;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.isEnabled()) {
            this.selectedSlider = this.rslider.hitBox((float)x, (float)(y += (double)this.currentscrollpixels)) ? this.rslider : (this.gslider.hitBox((float)x, (float)y) ? this.gslider : (this.bslider.hitBox((float)x, (float)y) ? this.bslider : (this.aslider.hitBox((float)x, (float)y) ? this.aslider : null)));
            this.colourBox.addColour(x, y);
            this.colourBox.removeColour(x, y);
            if (this.colourLabel.hitbox((float)x, (float)y) && this.colours().length > this.selectedColour) {
                Minecraft.func_71410_x().field_195559_v.func_197960_a(new Colour(this.selectedColour).hexColour());
            }
        }
        return false;
    }

    public int[] getIntArray(IntArrayNBT e) {
        if (e == null) {
            return new int[0];
        }
        return e.func_150302_c();
    }

    class ScrollableColourBox
    extends ScrollableRectangle {
        public ScrollableColourBox(MuseRelativeRect relativeRect) {
            super(relativeRect);
        }

        boolean addColour(double x, double y) {
            if (y > this.centery() + 8.5 && y < this.centery() + 16.5) {
                int colourCol = (int)(x - this.left() - 8.0) / 8;
                if (colourCol >= 0 && colourCol < ColourPickerFrame.this.colours().length) {
                    ColourPickerFrame.this.onSelectColour(colourCol);
                } else if (colourCol == ColourPickerFrame.this.colours().length) {
                    MuseLogger.logger.debug("Adding");
                    List<Integer> intList = Arrays.stream(ColourPickerFrame.this.getIntArray(ColourPickerFrame.this.getOrCreateColourTag())).boxed().collect(Collectors.toList());
                    intList.add(Colour.WHITE.getInt());
                    ColourPickerFrame.this.setColourTagMaybe(intList);
                }
                return true;
            }
            return false;
        }

        boolean removeColour(double x, double y) {
            if (y > this.centery() + 0.5 && y < this.centery() + 8.5 && x > this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8) && x < this.left() + 16.0 + (double)(ColourPickerFrame.this.selectedColour * 8)) {
                IntArrayNBT IntArrayNBT2 = ColourPickerFrame.this.getOrCreateColourTag();
                List<Integer> intList = Arrays.stream(ColourPickerFrame.this.getIntArray(IntArrayNBT2)).boxed().collect(Collectors.toList());
                if (intList.size() > 1 && ColourPickerFrame.this.selectedColour <= intList.size() - 1) {
                    intList.remove(ColourPickerFrame.this.selectedColour);
                    ColourPickerFrame.this.setColourTagMaybe(intList);
                    ColourPickerFrame.this.decrAbove = ColourPickerFrame.this.selectedColour;
                    if (ColourPickerFrame.this.selectedColour == ColourPickerFrame.this.getIntArray(IntArrayNBT2).length) {
                        --ColourPickerFrame.this.selectedColour;
                    }
                    ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                    if (player.field_70170_p.field_72995_K) {
                        MPSPackets.CHANNEL_INSTANCE.sendToServer((Object)new ColourInfoPacket(ColourPickerFrame.this.itemSelector.getSelectedItem().getSlotIndex(), IntArrayNBT2.func_150302_c()));
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks, float zLevel) {
            GuiIcon icon = MuseIconUtils.getIcon();
            for (int i = 0; i < ColourPickerFrame.this.colours().length; ++i) {
                icon.armorColourPatch.draw(matrixStack, this.left() + 8.0 + (double)(i * 8), this.centery() + 8.0, new Colour(ColourPickerFrame.this.colours()[i]));
            }
            icon.armorColourPatch.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.colours().length * 8), this.centery() + 8.0, Colour.WHITE);
            icon.selectedArmorOverlay.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8), this.centery() + 8.0, Colour.WHITE);
            icon.minusSign.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.selectedColour * 8), this.centery(), Colour.RED);
            icon.plusSign.draw(matrixStack, this.left() + 8.0 + (double)(ColourPickerFrame.this.colours().length * 8), this.centery() + 8.0, Colour.GREEN);
        }
    }
}

