/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.cosmetic;

import com.github.lehjr.numina.util.capabilities.render.modelspec.EnumSpecType;
import com.github.lehjr.numina.util.capabilities.render.modelspec.ModelRegistry;
import com.github.lehjr.numina.util.capabilities.render.modelspec.SpecBase;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableItem;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.client.gui.common.ItemSelectionFrame;
import com.github.lehjr.powersuits.client.gui.modding.cosmetic.ColourPickerFrame;
import com.github.lehjr.powersuits.client.gui.modding.cosmetic.PartSpecManipSubFrame;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;

public class PartManipContainer
extends ScrollableFrame {
    public ItemSelectionFrame itemSelect;
    public ColourPickerFrame colourSelect;
    public ClickableItem lastItemSlot;
    public int lastColour;
    public int lastColourIndex;
    public List<PartSpecManipSubFrame> modelframes;

    public PartManipContainer(ItemSelectionFrame itemSelect, ColourPickerFrame colourSelect, MusePoint2D topleft, MusePoint2D bottomright, float zlevel, Colour borderColour, Colour insideColour) {
        super(topleft, bottomright, zlevel, borderColour, insideColour);
        this.itemSelect = itemSelect;
        this.colourSelect = colourSelect;
        this.lastItemSlot = null;
        this.lastColour = this.getColour();
        this.lastColourIndex = this.getColourIndex();
    }

    public void init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
        if (this.itemSelect.hasNoItems()) {
            this.disable();
            this.hide();
        } else {
            this.enable();
            this.show();
            this.getModelframes();
        }
    }

    @Nonnull
    public ItemStack getItem() {
        return this.itemSelect.getSelectedItem() != null ? this.itemSelect.getSelectedItem().getStack() : ItemStack.field_190927_a;
    }

    public int getColour() {
        if (this.getItem().func_190926_b()) {
            return Colour.WHITE.getInt();
        }
        if (this.colourSelect.selectedColour < this.colourSelect.colours().length && this.colourSelect.selectedColour >= 0) {
            return this.colourSelect.colours()[this.colourSelect.selectedColour];
        }
        return Colour.WHITE.getInt();
    }

    public int getColourIndex() {
        return this.colourSelect.selectedColour;
    }

    public void getModelframes() {
        this.modelframes = new ArrayList<PartSpecManipSubFrame>();
        if (!this.getItem().func_190926_b()) {
            Iterable specCollection = ModelRegistry.getInstance().getSpecs();
            PartSpecManipSubFrame prev = null;
            for (SpecBase modelspec : specCollection) {
                PartSpecManipSubFrame newframe;
                if (!this.isSpecValid(modelspec)) continue;
                prev = newframe = this.createNewFrame(modelspec, prev);
                this.modelframes.add(newframe);
            }
        }
    }

    boolean isSpecValid(SpecBase specBase) {
        if (!this.getItem().func_190926_b()) {
            Item item = this.getItem().func_77973_b();
            if (item instanceof ArmorItem) {
                EquipmentSlotType slotType = ((ArmorItem)item).func_185083_B_();
                return specBase.getSpecType().equals((Object)EnumSpecType.ARMOR_MODEL) || specBase.getSpecType().equals((Object)EnumSpecType.ARMOR_SKIN) && this.doesSpecHaveSlotType(specBase, slotType);
            }
            if (item instanceof ToolItem) {
                return specBase.getSpecType().equals((Object)EnumSpecType.HANDHELD) && this.doesSpecHaveSlotType(specBase, EquipmentSlotType.MAINHAND);
            }
            return specBase.getSpecType().equals((Object)EnumSpecType.HANDHELD) && this.doesSpecHaveSlotType(specBase, EquipmentSlotType.OFFHAND);
        }
        return false;
    }

    boolean doesSpecHaveSlotType(SpecBase specBase, EquipmentSlotType slot) {
        AtomicBoolean hasType = new AtomicBoolean(false);
        specBase.getPartSpecs().forEach(spec -> {
            if (spec.getBinding().getSlot().equals((Object)slot)) {
                hasType.set(true);
            }
        });
        return hasType.get();
    }

    public PartSpecManipSubFrame createNewFrame(SpecBase modelspec, PartSpecManipSubFrame prev) {
        MuseRelativeRect newborder = new MuseRelativeRect(this.border.finalLeft() + 4.0, this.border.finalTop() + 4.0, this.border.finalRight(), this.border.finalTop() + 10.0);
        newborder.setMeBelow((MuseRect)(prev != null ? prev.border : null));
        return new PartSpecManipSubFrame(modelspec, this.colourSelect, this.itemSelect, newborder, this.zLevel);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.isEnabled() && this.isVisible() && button == 0) {
            for (PartSpecManipSubFrame frame : this.modelframes) {
                if (!frame.tryMouseClick(x, y + (double)this.currentscrollpixels)) continue;
                return true;
            }
        }
        return false;
    }

    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
        if (this.itemSelect.hasNoItems()) {
            this.disable();
            this.hide();
        } else if (this.itemSelect.getSelectedItem() != null) {
            this.enable();
            this.show();
            if (!Objects.equals(this.lastItemSlot, this.itemSelect.getSelectedItem())) {
                this.lastItemSlot = this.itemSelect.getSelectedItem();
                double x = 0.0;
                for (PartSpecManipSubFrame subframe : this.modelframes) {
                    subframe.updateItems();
                    x += subframe.border.bottom();
                }
                this.totalsize = (int)x;
            }
            if (this.colourSelect.decrAbove > -1) {
                this.decrAbove(this.colourSelect.decrAbove);
                this.colourSelect.decrAbove = -1;
            }
        }
    }

    public void decrAbove(int index) {
        for (PartSpecManipSubFrame frame : this.modelframes) {
            frame.decrAbove(index);
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible() && !this.modelframes.isEmpty()) {
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)(-this.currentscrollpixels), (double)0.0);
            for (PartSpecManipSubFrame f : this.modelframes) {
                f.drawPartial(matrixStack, (double)(this.currentscrollpixels + 4) + this.border.finalTop(), (double)this.currentscrollpixels + this.border.finalBottom() - 4.0);
            }
            RenderSystem.popMatrix();
            super.postRender(mouseX, mouseY, partialTicks);
        } else {
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            super.postRender(mouseX, mouseY, partialTicks);
        }
    }
}

