/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.module;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.item.ItemUtils;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.github.lehjr.powersuits.client.gui.common.ItemSelectionFrame;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;

public class DetailedSummaryFrame
extends ScrollableFrame {
    protected PlayerEntity player;
    protected int energy;
    protected double armor;
    protected ItemSelectionFrame itemSelectionFrame;

    public DetailedSummaryFrame(PlayerEntity player, MusePoint2D topleft, MusePoint2D bottomright, float zLevel, Colour borderColour, Colour insideColour, ItemSelectionFrame itemSelectionFrame) {
        super(topleft, bottomright, zLevel, borderColour, insideColour);
        this.player = player;
        this.itemSelectionFrame = itemSelectionFrame;
    }

    public void update(double mousex, double mousey) {
        this.energy = ElectricItemUtils.getPlayerEnergy((LivingEntity)this.player);
        this.armor = 0.0;
        for (ItemStack stack : ItemUtils.getModularItemsEquipped((PlayerEntity)this.player)) {
            this.energy += ElectricItemUtils.getItemEnergy((ItemStack)stack);
            AtomicDouble atomicArmor = new AtomicDouble(0.0);
            stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iModularItem -> {
                if (iModularItem instanceof IModularItem) {
                    for (ItemStack module : ((IModularItem)iModularItem).getInstalledModules()) {
                        module.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(iPowerModule -> {
                            atomicArmor.getAndAdd(iPowerModule.applyPropertyModifiers("armorPhysical"));
                            atomicArmor.getAndAdd(iPowerModule.applyPropertyModifiers("armorEnergy"));
                        });
                    }
                }
            });
            this.armor += atomicArmor.get();
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.player != null) {
            int i;
            super.render(matrixStack, mouseX, mouseY, partialTicks);
            int margin = 4;
            int nexty = (int)this.border.top() + margin;
            MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)I18n.func_135052_a((String)"gui.powersuits.equippedTotals", (Object[])new Object[0]), (double)((this.border.left() + this.border.right()) / 2.0), (double)nexty);
            nexty += 10;
            String formattedValue = MuseStringUtils.formatNumberFromUnits((double)this.energy, (String)"FE");
            String name = I18n.func_135052_a((String)"gui.powersuits.energyStorage", (Object[])new Object[0]);
            double valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
            double allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
            List namesList = MuseStringUtils.wrapStringToVisualLength((String)name, (double)allowedNameWidth);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawString((MatrixStack)matrixStack, (String)((String)namesList.get(i)), (double)(this.border.left() + (double)margin), (double)(nexty + 9 * i));
            }
            MuseRenderer.drawRightAlignedString((MatrixStack)matrixStack, (String)formattedValue, (double)(this.border.right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
            nexty += 10 * namesList.size() + 1;
            formattedValue = MuseStringUtils.formatNumberFromUnits((double)this.armor, (String)"pts");
            name = I18n.func_135052_a((String)"gui.powersuits.armor", (Object[])new Object[0]);
            valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
            allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
            namesList = MuseStringUtils.wrapStringToVisualLength((String)name, (double)allowedNameWidth);
            assert (namesList != null);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawString((MatrixStack)matrixStack, (String)((String)namesList.get(i)), (double)(this.border.left() + (double)margin), (double)(nexty + 9 * i));
            }
            MuseRenderer.drawRightAlignedString((MatrixStack)matrixStack, (String)formattedValue, (double)(this.border.right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
        }
    }
}

