/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.module;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableButton;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableItem;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.sound.SoundDictionary;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.github.lehjr.powersuits.client.gui.common.ItemSelectionFrame;
import com.github.lehjr.powersuits.client.gui.modding.module.ModuleSelectionFrame;
import com.github.lehjr.powersuits.container.MPSWorkbenchContainer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class InstallSalvageFrame
extends ScrollableFrame {
    MPSWorkbenchContainer container;
    protected ItemSelectionFrame targetItem;
    protected ModuleSelectionFrame targetModule;
    protected ClickableButton installButton;
    protected ClickableButton salvageButton;
    protected PlayerEntity player;
    Minecraft mc;
    float zLevel;

    public InstallSalvageFrame(MPSWorkbenchContainer containerIn, PlayerEntity player, MusePoint2D topleft, MusePoint2D bottomright, float zLevel, Colour backgroundColour, Colour borderColour, ItemSelectionFrame targetItem, ModuleSelectionFrame targetModule) {
        super(topleft, bottomright, zLevel, backgroundColour, borderColour);
        this.container = containerIn;
        this.player = player;
        this.targetItem = targetItem;
        this.targetModule = targetModule;
        double sizex = this.border.right() - this.border.left();
        double sizey = this.border.bottom() - this.border.top();
        this.mc = Minecraft.func_71410_x();
        this.installButton = new ClickableButton((ITextComponent)new TranslationTextComponent("gui.powersuits.install"), new MusePoint2D(this.border.right() - sizex / 2.0, this.border.bottom() - sizey / 4.0), true);
        this.installButton.setOnPressed(press -> {
            if (targetItem.getSelectedItem() == null || targetModule.getSelectedModule() == null) {
                return;
            }
            ItemStack module = targetModule.getSelectedModule().getModule();
            Integer containerIndex = targetItem.getSelectedItem().containerIndex;
            int moduleTarget = -1;
            if (containerIndex != null) {
                moduleTarget = this.getModuleTargetIndexInModularItem(containerIndex, targetModule.getSelectedModule().getModule());
            }
            if (moduleTarget != -1) {
                if (player.field_71075_bZ.field_75098_d) {
                    player.func_184185_a(SoundDictionary.SOUND_EVENT_GUI_INSTALL, 1.0f, 0.0f);
                    containerIn.creativeInstall(moduleTarget, new ItemStack((IItemProvider)module.func_77973_b()));
                } else {
                    int sourceIndex = this.getContainerIndexForModuleIndexInPlayerInventory(module);
                    player.func_184185_a(SoundDictionary.SOUND_EVENT_GUI_INSTALL, 1.0f, 0.0f);
                    containerIn.move(sourceIndex, moduleTarget);
                }
            }
        });
        this.salvageButton = new ClickableButton((ITextComponent)new TranslationTextComponent("gui.powersuits.salvage"), new MusePoint2D(this.border.left() + sizex / 2.0, this.border.top() + sizey / 4.0), true);
        this.salvageButton.setOnPressed(pressed -> {
            Integer containerIndex;
            if (targetItem.getSelectedItem() != null && targetModule.getSelectedModule() != null && targetModule.getSelectedModule().isInstalled() && (containerIndex = targetItem.getSelectedItem().containerIndex) != null) {
                int targetIndex;
                List<SlotItemHandler> slots = this.container.getModularItemToSlotMap().get(targetItem.getSelectedItem().containerIndex);
                Integer moduleContainerIndex = null;
                for (SlotItemHandler slot : slots) {
                    if (!ItemStack.func_77989_b((ItemStack)slot.func_75211_c(), (ItemStack)targetModule.getSelectedModule().getModule())) continue;
                    moduleContainerIndex = slot.field_75222_d;
                    break;
                }
                if (moduleContainerIndex != null && (targetIndex = this.getModuleTargetIndexInPlayerInventory(targetModule.getSelectedModule().getModule())) > 0) {
                    player.func_184185_a(SoundDictionary.SOUND_EVENT_GUI_SELECT, 1.0f, 0.0f);
                    this.container.move(moduleContainerIndex, targetIndex);
                }
            }
        });
    }

    int getContainerIndexForModuleIndexInPlayerInventory(@Nonnull ItemStack module) {
        if (module.func_190926_b()) {
            return -1;
        }
        for (Slot slot : this.container.field_75151_b) {
            if (slot.func_75211_c().func_190926_b() || slot.field_75224_c != this.player.field_71071_by || !slot.func_75211_c().func_77969_a(module)) continue;
            return slot.field_75222_d;
        }
        return -1;
    }

    int getModuleTargetIndexInPlayerInventory(@Nonnull ItemStack module) {
        int index = -1;
        int targetIndex = this.player.field_71071_by.func_70447_i();
        for (Slot slot : this.container.field_75151_b) {
            if (slot.field_75224_c != this.player.field_71071_by || targetIndex != slot.getSlotIndex()) continue;
            return this.container.field_75151_b.indexOf(slot);
        }
        return index;
    }

    int getModuleTargetIndexInModularItem(int modularItemIndex, @Nonnull ItemStack module) {
        Slot slot = this.container.func_75139_a(modularItemIndex);
        if (slot == null) {
            return -1;
        }
        List<SlotItemHandler> slots = this.container.getModularItemToSlotMap().get(modularItemIndex);
        int slotIndex = -1;
        for (SlotItemHandler slotItemHandler : slots) {
            int index = slotItemHandler.getSlotIndex();
            if (!(slotItemHandler.getItemHandler() instanceof IModularItem) || !slotItemHandler.getItemHandler().insertItem(index, module, true).func_190926_b()) continue;
            slotIndex = slotItemHandler.field_75222_d;
            break;
        }
        return slotIndex;
    }

    public void init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
    }

    public void update(double x, double y) {
        super.update(x, y);
        double sizex = this.border.finalWidth();
        double sizey = this.border.finalHeight();
        this.installButton.setPosition(new MusePoint2D(this.border.left() + sizex / 2.0, this.border.bottom() - sizey / 2.0));
        this.salvageButton.setPosition(new MusePoint2D(this.border.left() + sizex / 2.0, this.border.bottom() - sizey / 2.0));
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            ClickableModule selectedModule = this.targetModule.getSelectedModule();
            if (selectedModule.isInstalled()) {
                this.salvageButton.enableAndShow();
                this.installButton.disableAndHide();
            } else if (this.player.field_71075_bZ.field_75098_d || this.player.field_71071_by.func_70431_c(selectedModule.getModule())) {
                this.salvageButton.disableAndHide();
                this.installButton.enableAndShow();
            } else {
                this.salvageButton.disableAndHide();
                this.installButton.disableAndHide();
            }
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        TranslationTextComponent ret = null;
        if (this.salvageButton.isVisible() && this.salvageButton.hitBox((double)x, (double)y)) {
            ret = new TranslationTextComponent("gui.powersuits.salvage.desc");
        }
        if (this.installButton.isVisible() && this.installButton.hitBox((double)x, (double)y)) {
            if (this.installButton.isEnabled() && this.player.field_71075_bZ.field_75098_d) {
                ret = new TranslationTextComponent("gui.powersuits.install.creative.desc");
            } else if (this.installButton.isEnabled()) {
                Collections.singletonList(new TranslationTextComponent("gui.powersuits.install.desc"));
            } else {
                ret = new TranslationTextComponent("gui.powersuits.install.disabled.desc");
            }
        }
        if (ret != null) {
            return MuseStringUtils.wrapITextComponentToLength(ret, (int)30);
        }
        return null;
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawBackground(matrixStack, mouseX, mouseY, partialTicks);
        if (this.targetItem.getSelectedItem() != null && this.targetModule.getSelectedModule() != null) {
            this.drawButtons(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    private void drawBackground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void drawButtons(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.salvageButton.render(matrixStack, mouseX, mouseY, partialTicks, this.zLevel);
        this.installButton.render(matrixStack, mouseX, mouseY, partialTicks, this.zLevel);
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (!this.border.containsPoint(x, y)) {
            return false;
        }
        ClickableItem selectedItem = this.targetItem.getSelectedItem();
        ClickableModule selectedModule = this.targetModule.getSelectedModule();
        AtomicBoolean handled = new AtomicBoolean(false);
        if (selectedItem != null && !selectedItem.getStack().func_190926_b() && selectedModule != null && !selectedModule.getModule().func_190926_b()) {
            selectedItem.getStack().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(cap -> {
                if (cap instanceof IModularItem) {
                    if (((IModularItem)cap).isModuleInstalled(selectedModule.getModule().func_77973_b().getRegistryName())) {
                        if (this.salvageButton.mouseClicked(x, y, button)) {
                            handled.set(true);
                        }
                    } else if (this.installButton.mouseClicked(x, y, button)) {
                        handled.set(true);
                    }
                }
            });
        }
        return handled.get();
    }

    public void setUlShift(MusePoint2D ulOffset) {
    }
}

