/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.module;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableItem;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.basemod.MPSModules;
import com.github.lehjr.powersuits.client.gui.common.ItemSelectionFrame;
import com.github.lehjr.powersuits.client.gui.modding.module.ModuleSelectionSubFrame;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ModuleSelectionFrame
extends ScrollableFrame {
    protected ItemSelectionFrame target;
    protected Map<EnumModuleCategory, ModuleSelectionSubFrame> categories = new LinkedHashMap<EnumModuleCategory, ModuleSelectionSubFrame>();
    protected MuseRect lastPosition;
    OnSelectNewModule doThis;

    public ModuleSelectionFrame(ItemSelectionFrame itemSelectFrameIn, MusePoint2D topleft, MusePoint2D bottomright, float zLevel, Colour backgroundColour, Colour borderColour) {
        super(topleft, bottomright, zLevel, backgroundColour, borderColour);
        this.target = itemSelectFrameIn;
    }

    private ModuleSelectionSubFrame getOrCreateCategory(EnumModuleCategory category) {
        if (this.categories.containsKey(category)) {
            return this.categories.get(category);
        }
        MuseRelativeRect position = new MuseRelativeRect(this.border.left() + 4.0, this.border.top() + 4.0, this.border.right() - 4.0, this.border.top() + 36.0);
        position.setMeBelow(this.lastPosition);
        this.lastPosition = position;
        ModuleSelectionSubFrame frame = new ModuleSelectionSubFrame(category, position);
        this.categories.put(category, frame);
        return frame;
    }

    public void loadModules(boolean preserveSelected) {
        this.lastPosition = null;
        ClickableModule selCopy = this.getSelectedModule();
        ClickableItem selectedItem = this.target.getSelectedItem();
        if (selectedItem != null) {
            if (!preserveSelected) {
                selCopy = null;
            } else if (this.getSelectedModule() != null) {
                ClickableModule sel = this.getSelectedModule();
                selCopy = new ClickableModule(sel.getModule(), new MusePoint2D(0.0, 0.0), -1, sel.category);
            }
            this.categories = new LinkedHashMap<EnumModuleCategory, ModuleSelectionSubFrame>();
            selectedItem.getStack().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                if (itemHandler instanceof IModularItem) {
                    ArrayList<ResourceLocation> moduleRegNameList = new ArrayList<ResourceLocation>(MPSModules.INSTANCE.getModuleRegNames());
                    for (ResourceLocation regName : moduleRegNameList) {
                        if (((IModularItem)itemHandler).isModuleInstalled(regName)) continue;
                        ItemStack module = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(regName));
                        EnumModuleCategory category = module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.getCategory()).orElse(EnumModuleCategory.NONE);
                        if (!((IModularItem)itemHandler).isModuleValid(module)) continue;
                        ModuleSelectionSubFrame frame = this.getOrCreateCategory(category);
                        ClickableModule clickie = frame.addModule(module, -1);
                        clickie.setInstalled(false);
                    }
                    int index = 0;
                    while (index < itemHandler.getSlots()) {
                        ItemStack module = itemHandler.getStackInSlot(index);
                        int finalIndex = index++;
                        module.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(m -> {
                            if (m.isAllowed()) {
                                ModuleSelectionSubFrame frame = this.getOrCreateCategory(m.getCategory());
                                ClickableModule clickie = frame.addModule(module, finalIndex);
                                clickie.setInstalled(true);
                            }
                        });
                    }
                }
            });
        }
        block0: for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.refreshButtonPositions();
            if (!preserveSelected || selCopy == null || frame.category != selCopy.category) continue;
            for (ClickableModule button : frame.moduleButtons) {
                if (!button.getModule().func_77969_a(selCopy.getModule())) continue;
                frame.selectedModule = frame.moduleButtons.indexOf(button);
                preserveSelected = false;
                continue block0;
            }
        }
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.refreshButtonPositions();
            if (this.target.getSelectedItem() == null) continue;
            frame.refreshModules(this.target.getSelectedItem().getStack());
        }
        if (this.target.getSelectedItem() != null) {
            this.totalsize = 0;
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                this.totalsize = (int)Math.max(frame.border.bottom() - this.border.top(), (double)this.totalsize);
            }
            this.currentscrollpixels = Math.min(this.currentscrollpixels, this.getMaxScrollPixels());
            super.preRender(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)(-this.currentscrollpixels), (float)0.0f);
            this.drawItems(matrixStack, partialTicks, this.getzLevel());
            this.drawSelection(matrixStack);
            RenderSystem.popMatrix();
            super.postRender(mouseX, mouseY, partialTicks);
        } else {
            super.render(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    private void drawItems(MatrixStack matrixStack, float partialTicks, float zLevel) {
        for (ModuleSelectionSubFrame frame : this.categories.values()) {
            frame.drawPartial(matrixStack, (int)((double)this.currentscrollpixels + this.border.top() + 4.0), (int)((double)this.currentscrollpixels + this.border.top() + this.border.height() - 4.0), partialTicks, zLevel);
        }
    }

    private void drawSelection(MatrixStack matrixStack) {
        MusePoint2D pos;
        ClickableModule module = this.getSelectedModule();
        if (module != null && (pos = module.getPosition()).getY() > (double)this.currentscrollpixels + this.border.top() + 4.0 && pos.getY() < (double)this.currentscrollpixels + this.border.top() + this.border.height() - 4.0) {
            MuseRenderer.drawCircleAround((MatrixStack)matrixStack, (double)pos.getX(), (double)pos.getY(), (double)10.0, (float)this.getzLevel());
        }
    }

    public ClickableModule getSelectedModule() {
        ClickableModule ret;
        block1: {
            ModuleSelectionSubFrame frame;
            ret = null;
            if (this.categories.isEmpty()) break block1;
            Iterator<ModuleSelectionSubFrame> iterator = this.categories.values().iterator();
            while (iterator.hasNext() && (ret = (frame = iterator.next()).getSelectedModule()) == null) {
            }
        }
        return ret;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (super.mouseClicked(x, y, button)) {
            return true;
        }
        ModuleSelectionSubFrame sel = null;
        if (this.border.containsPoint(x, y)) {
            y += (double)this.currentscrollpixels;
            boolean i = false;
            for (ModuleSelectionSubFrame frame : this.categories.values()) {
                if (!frame.mouseClicked(x, y, button)) continue;
                sel = frame;
            }
            if (sel != null && sel.getSelectedModule() != null) {
                for (ModuleSelectionSubFrame frame : this.categories.values()) {
                    if (frame == sel) continue;
                    frame.resetSelection();
                }
            }
        }
        return sel != null;
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.border.containsPoint((double)x, (double)y)) {
            y += this.currentscrollpixels;
            if (!this.categories.isEmpty()) {
                for (ModuleSelectionSubFrame category : this.categories.values()) {
                    List<ITextComponent> tooltip = category.getToolTip(x, y);
                    if (tooltip == null) continue;
                    return tooltip;
                }
            }
        }
        return null;
    }

    public void setDoOnNewSelect(OnSelectNewModule doThisIn) {
        this.doThis = doThisIn;
    }

    void onSelected() {
        if (this.doThis != null) {
            this.doThis.onSelected(this);
        }
    }

    public static interface OnSelectNewModule {
        public void onSelected(ModuleSelectionFrame var1);
    }
}

