/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.module;

import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRelativeRect;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.client.sound.Musique;
import com.github.lehjr.numina.util.client.sound.SoundDictionary;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModuleSelectionSubFrame {
    protected List<ClickableModule> moduleButtons;
    protected MuseRelativeRect border;
    protected EnumModuleCategory category;
    int selectedModule = -1;

    public ModuleSelectionSubFrame(EnumModuleCategory category, MuseRelativeRect border) {
        this.category = category;
        this.border = border;
        this.moduleButtons = new ArrayList<ClickableModule>();
    }

    public ClickableModule addModule(@Nonnull ItemStack module, int index) {
        ClickableModule clickie = new ClickableModule(module, new MusePoint2D(0.0, 0.0), index, this.category);
        this.moduleButtons.add(clickie);
        this.refreshButtonPositions();
        return clickie;
    }

    public ClickableModule replaceModule(@Nonnull ItemStack module, int index) {
        int moduleIndex = -1;
        MusePoint2D position = null;
        for (ClickableModule clickie : this.moduleButtons) {
            if (!module.func_77969_a(clickie.getModule())) continue;
            moduleIndex = this.moduleButtons.indexOf(clickie);
            position = clickie.getPosition();
            break;
        }
        if (moduleIndex != -1 && position != null) {
            ClickableModule clickie = new ClickableModule(module, position, index, this.category);
            clickie.setInstalled(index >= 0);
            this.moduleButtons.set(moduleIndex, clickie);
            return clickie;
        }
        return this.addModule(module, index);
    }

    public void drawPartial(MatrixStack matrixStack, int min, int max, float partialTicks, float zLevel) {
        this.refreshButtonPositions();
        double top = this.border.top();
        MuseRenderer.drawString((MatrixStack)matrixStack, (String)this.category.getName(), (double)this.border.left(), (double)top);
        for (ClickableModule clickie : this.moduleButtons) {
            clickie.render(matrixStack, min, max, partialTicks, zLevel);
        }
    }

    public void refreshModules(@Nonnull ItemStack selectedItem) {
        selectedItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            if (h instanceof IModularItem) {
                for (ClickableModule module : this.moduleButtons) {
                    boolean markForUpdate = false;
                    int slot = -1;
                    for (int i = 0; i < h.getSlots(); ++i) {
                        if (!h.getStackInSlot(i).func_77969_a(module.getModule())) continue;
                        slot = i;
                        if (ItemStack.func_77989_b((ItemStack)h.getStackInSlot(i), (ItemStack)module.getModule())) continue;
                        markForUpdate = true;
                    }
                    if (module.isInstalled() && slot == -1) {
                        ItemStack newModule = new ItemStack((IItemProvider)module.getModule().func_77973_b());
                        this.replaceModule(newModule, slot);
                        continue;
                    }
                    if ((module.isInstalled() || slot == -1) && !markForUpdate) continue;
                    ItemStack newModule = h.getStackInSlot(slot);
                    this.replaceModule(newModule, slot);
                }
            }
        });
    }

    public void refreshButtonPositions() {
        int col = 0;
        int row = 0;
        int topMargin = 20;
        int leftMargin = 10;
        for (ClickableModule clickie : this.moduleButtons) {
            if (col > 4) {
                col = 0;
                ++row;
            }
            double x = this.border.left() + (double)leftMargin + (double)(20 * col);
            double y = this.border.top() + (double)topMargin + (double)(20 * row);
            clickie.setPosition(new MusePoint2D(x, y));
            ++col;
        }
        this.border.setHeight((double)(topMargin * 2 + 20 * row));
    }

    public ClickableModule getSelectedModule() {
        if (this.selectedModule >= 0) {
            return this.moduleButtons.get(this.selectedModule);
        }
        return null;
    }

    public void resetSelection() {
        this.selectedModule = -1;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (this.border.containsPoint(x, y)) {
            for (ClickableModule module : this.moduleButtons) {
                if (!module.hitBox((double)((float)x), (double)((float)y))) continue;
                Musique.playClientSound((SoundEvent)SoundDictionary.SOUND_EVENT_GUI_SELECT, (float)1.0f);
                this.selectedModule = this.moduleButtons.indexOf(module);
                return true;
            }
        }
        return false;
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        if (this.border.containsPoint((double)x, (double)y) && this.moduleButtons != null) {
            for (ClickableModule module : this.moduleButtons) {
                if (!module.hitBox((double)x, (double)y)) continue;
                return module.getToolTip();
            }
        }
        return null;
    }

    public MuseRect getBorder() {
        return this.border;
    }
}

