/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modding.module;

import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.network.packets.TweakRequestDoublePacket;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableItem;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableTinkerSlider;
import com.github.lehjr.numina.util.client.gui.frame.ScrollableFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import com.github.lehjr.numina.util.nbt.propertymodifier.IPropertyModifier;
import com.github.lehjr.numina.util.nbt.propertymodifier.PropertyModifierLinearAdditive;
import com.github.lehjr.numina.util.string.MuseStringUtils;
import com.github.lehjr.powersuits.client.gui.common.ItemSelectionFrame;
import com.github.lehjr.powersuits.client.gui.modding.module.ModuleSelectionFrame;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModuleTweakFrame
extends ScrollableFrame {
    protected static int margin = 4;
    protected ItemSelectionFrame itemTarget;
    protected ModuleSelectionFrame moduleTarget;
    protected List<ClickableTinkerSlider> sliders;
    protected Map<String, Double> propertyDoubleStrings;
    protected ClickableTinkerSlider selectedSlider;

    public ModuleTweakFrame(MusePoint2D topleft, MusePoint2D bottomright, float zLevel, Colour borderColour, Colour insideColour, ItemSelectionFrame itemTarget, ModuleSelectionFrame moduleTarget) {
        super(topleft, bottomright, zLevel, borderColour, insideColour);
        this.itemTarget = itemTarget;
        this.moduleTarget = moduleTarget;
    }

    public void update(double mousex, double mousey) {
        if (this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ItemStack stack = this.itemTarget.getSelectedItem().getStack();
            ItemStack module = this.moduleTarget.getSelectedModule().getModule();
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
                if (iItemHandler instanceof IModularItem) {
                    return ((IModularItem)iItemHandler).isModuleInstalled(module.func_77973_b().getRegistryName());
                }
                return false;
            }).orElse(false).booleanValue()) {
                this.loadTweaks(module);
            } else {
                this.sliders = null;
                this.propertyDoubleStrings = null;
            }
        } else {
            this.sliders = null;
            this.propertyDoubleStrings = null;
        }
        if (this.selectedSlider != null) {
            this.selectedSlider.setValueByX(mousex);
        }
    }

    String getUnit(String key) {
        if (this.moduleTarget.getSelectedModule() != null) {
            return this.moduleTarget.getSelectedModule().getModule().getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm.getUnit(key)).orElse("");
        }
        return "";
    }

    public void init(double left, double top, double right, double bottom) {
        super.init(left, top, right, bottom);
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.sliders != null) {
            super.render(matrixStack, mouseX, mouseY, partialTicks);
            MuseRenderer.drawCenteredString((MatrixStack)matrixStack, (String)"Tinker", (double)((this.border.left() + this.border.right()) / 2.0), (double)(this.border.top() + 2.0));
            for (ClickableTinkerSlider slider : this.sliders) {
                slider.render(matrixStack, mouseX, mouseY, partialTicks, this.getzLevel());
            }
            int nexty = (int)((double)(this.sliders.size() * 20) + this.border.top() + 23.0);
            for (Map.Entry<String, Double> property : this.propertyDoubleStrings.entrySet()) {
                String formattedValue = MuseStringUtils.formatNumberFromUnits((double)property.getValue(), (String)this.getUnit(property.getKey()));
                String name = property.getKey();
                double valueWidth = MuseRenderer.getStringWidth((String)formattedValue);
                double allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
                List namesList = MuseStringUtils.wrapStringToVisualLength((String)I18n.func_135052_a((String)("module.tradeoff." + name), (Object[])new Object[0]), (double)allowedNameWidth);
                for (int i = 0; i < namesList.size(); ++i) {
                    MuseRenderer.drawString((MatrixStack)matrixStack, (String)((String)namesList.get(i)), (double)(this.border.left() + (double)margin), (double)(nexty + 9 * i));
                }
                MuseRenderer.drawRightAlignedString((MatrixStack)matrixStack, (String)formattedValue, (double)(this.border.right() - (double)margin), (double)(nexty + 9 * (namesList.size() - 1) / 2));
                nexty += 9 * namesList.size() + 1;
            }
        }
    }

    private void loadTweaks(@Nonnull ItemStack module) {
        this.propertyDoubleStrings = new HashMap<String, Double>();
        HashSet tweaks = new HashSet();
        CompoundNBT moduleTag = MuseNBTUtils.getModuleTag((ItemStack)module);
        module.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(pm -> {
            Map propertyModifiers = pm.getPropertyModifiers();
            for (Map.Entry property : propertyModifiers.entrySet()) {
                double currValue = 0.0;
                for (IPropertyModifier modifier : (List)property.getValue()) {
                    currValue = modifier.applyModifier(moduleTag, currValue);
                    if (!(modifier instanceof PropertyModifierLinearAdditive)) continue;
                    tweaks.add(((PropertyModifierLinearAdditive)modifier).getTradeoffName());
                }
                this.propertyDoubleStrings.put((String)property.getKey(), currValue);
            }
        });
        this.sliders = new LinkedList<ClickableTinkerSlider>();
        int y = 0;
        for (String tweak : tweaks) {
            MusePoint2D center = new MusePoint2D(this.border.centerx(), this.border.top() + (double)(y += 20));
            ClickableTinkerSlider slider = new ClickableTinkerSlider(center, this.border.finalRight() - this.border.finalLeft() - 16.0, moduleTag, tweak, (ITextComponent)new TranslationTextComponent("module.tradeoff." + tweak));
            this.sliders.add(slider);
            if (this.selectedSlider == null || !slider.hitBox(center.getX(), center.getY())) continue;
            this.selectedSlider = slider;
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean handled = false;
        if (button == 0 && this.sliders != null) {
            for (ClickableTinkerSlider slider : this.sliders) {
                if (!slider.hitBox(x, y)) continue;
                this.selectedSlider = slider;
                handled = true;
                break;
            }
        }
        return handled;
    }

    public boolean mouseReleased(double x, double y, int button) {
        boolean handled = false;
        if (this.selectedSlider != null && this.itemTarget.getSelectedItem() != null && this.moduleTarget.getSelectedModule() != null) {
            ClickableItem item = this.itemTarget.getSelectedItem();
            ItemStack module = this.moduleTarget.getSelectedModule().getModule();
            NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new TweakRequestDoublePacket(item.inventorySlot, module.func_77973_b().getRegistryName(), this.selectedSlider.id(), this.selectedSlider.getValue()));
            handled = true;
        }
        if (button == 0) {
            this.selectedSlider = null;
            handled = true;
        }
        return handled;
    }
}

