/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.client.gui.modechanging;

import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.network.packets.ModeChangeRequestPacket;
import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.client.gui.clickable.ClickableModule;
import com.github.lehjr.numina.util.client.gui.frame.IGuiFrame;
import com.github.lehjr.numina.util.client.gui.gemoetry.IRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.MusePoint2D;
import com.github.lehjr.numina.util.client.gui.gemoetry.MuseRect;
import com.github.lehjr.numina.util.client.gui.gemoetry.SpiralPointToPoint2D;
import com.github.lehjr.numina.util.client.render.MuseRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;

public class RadialModeSelectionFrame
implements IGuiFrame {
    boolean visible = true;
    boolean enabled = true;
    protected final long spawnTime;
    protected List<ClickableModule> modeButtons = new ArrayList<ClickableModule>();
    protected int selectedModuleOriginal = -1;
    protected int selectedModuleNew = -1;
    protected PlayerEntity player;
    protected MusePoint2D center;
    protected double radius;
    protected ItemStack stack;
    MuseRect rect;
    float zLevel;

    public RadialModeSelectionFrame(MusePoint2D topleft, MusePoint2D bottomright, PlayerEntity player, float zLevel) {
        this.spawnTime = System.currentTimeMillis();
        this.player = player;
        this.rect = new MuseRect(topleft, bottomright);
        this.center = this.rect.center();
        this.radius = Math.min(this.rect.height(), this.rect.width());
        this.stack = player.field_71071_by.func_70448_g();
        this.zLevel = zLevel;
        this.loadItems();
    }

    public void init(double left, double top, double right, double bottom) {
        this.rect.setTargetDimensions(left, top, right, bottom);
        this.center = this.rect.center();
        this.radius = Math.min(this.rect.height(), this.rect.width());
        this.modeButtons.clear();
    }

    public boolean mouseClicked(double x, double y, int button) {
        return false;
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        return false;
    }

    public boolean mouseReleased(double x, double y, int button) {
        return false;
    }

    public void update(double mousex, double mousey) {
        this.loadItems();
        if (System.currentTimeMillis() - this.spawnTime > 250L) {
            this.selectModule((float)mousex, (float)mousey);
        }
        if (this.getSelectedModule() != null && this.selectedModuleOriginal != this.selectedModuleNew) {
            this.selectedModuleOriginal = this.selectedModuleNew;
            this.stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                if (handler instanceof IModeChangingItem) {
                    ((IModeChangingItem)handler).setActiveMode(this.getSelectedModule().getInventorySlot());
                    NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new ModeChangeRequestPacket(this.getSelectedModule().getInventorySlot(), this.player.field_71071_by.field_70461_c));
                }
            });
        }
    }

    public void render(MatrixStack matrixStackIn, int mouseX, int mouseY, float partialTicks) {
        for (ClickableModule mode : this.modeButtons) {
            mode.render(matrixStackIn, mouseX, mouseY, partialTicks, this.zLevel);
        }
        this.drawSelection(matrixStackIn);
    }

    private void loadItems() {
        if (this.player != null && this.modeButtons.isEmpty()) {
            this.stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
                if (handler instanceof IModeChangingItem) {
                    List modes = ((IModeChangingItem)handler).getValidModes();
                    int activeMode = ((IModeChangingItem)handler).getActiveMode();
                    if (activeMode > 0) {
                        this.selectedModuleOriginal = activeMode;
                    }
                    int modeNum = 0;
                    Iterator iterator = modes.iterator();
                    while (iterator.hasNext()) {
                        int mode = (Integer)iterator.next();
                        ClickableModule clickie = new ClickableModule(handler.getStackInSlot(mode), (MusePoint2D)new SpiralPointToPoint2D(this.center, this.radius, 4.71238898038469 - Math.PI * 2 * (double)modeNum / (double)modes.size(), 250.0), mode, EnumModuleCategory.NONE);
                        this.modeButtons.add(clickie);
                        ++modeNum;
                    }
                }
            });
        }
    }

    private void selectModule(float x, float y) {
        if (this.modeButtons != null) {
            int i = 0;
            for (ClickableModule module : this.modeButtons) {
                if (module.hitBox((double)x, (double)y)) {
                    this.selectedModuleNew = i;
                    break;
                }
                ++i;
            }
        }
    }

    public ClickableModule getSelectedModule() {
        if (this.modeButtons.size() > this.selectedModuleNew && this.selectedModuleNew != -1) {
            return this.modeButtons.get(this.selectedModuleNew);
        }
        return null;
    }

    public void drawSelection(MatrixStack matrixStackIn) {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            MusePoint2D pos = module.getPosition();
            MuseRenderer.drawCircleAround((MatrixStack)matrixStackIn, (double)pos.getX(), (double)pos.getY(), (double)10.0, (float)this.zLevel);
        }
    }

    public List<ITextComponent> getToolTip(int x, int y) {
        ClickableModule module = this.getSelectedModule();
        if (module != null) {
            return module.getToolTip();
        }
        return null;
    }

    public IRect getBorder() {
        return this.rect;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public IRect setLeft(double v) {
        return this.rect.setLeft(v);
    }

    public IRect setRight(double v) {
        return this.rect.setRight(v);
    }

    public IRect setTop(double v) {
        return this.rect.setTop(v);
    }

    public IRect setBottom(double v) {
        return this.rect.setBottom(v);
    }

    public IRect setWidth(double v) {
        return this.rect.setWidth(v);
    }

    public IRect setHeight(double v) {
        return this.rect.setHeight(v);
    }
}

