/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    protected ForgeConfigSpec.DoubleValue GENERAL_MAX_FLYING_SPEED;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_POWERFIST;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_HELMET;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_CHEST;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_LEGS;
    protected ForgeConfigSpec.DoubleValue GENERAL_BASE_MAX_HEAT_FEET;
    protected ForgeConfigSpec.ConfigValue<List<? extends String>> GENERAL_VEIN_MINER_ORE_LIST;
    protected ForgeConfigSpec.ConfigValue<List<?>> GENERAL_VEIN_MINER_BLOCK_LIST;
    protected ForgeConfigSpec.BooleanValue COSMETIC_USE_LEGACY_COSMETIC_SYSTEM;
    protected ForgeConfigSpec.BooleanValue COSMETIC_ALLOW_HIGH_POLLY_ARMOR_MODELS;
    protected ForgeConfigSpec.BooleanValue COSMETIC_ALLOW_POWER_FIST_CUSTOMIZATOIN;
    protected ForgeConfigSpec.BooleanValue RECIPES_USE_VANILLA;

    protected ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("General settings").push("General");
        this.GENERAL_MAX_FLYING_SPEED = builder.comment("Maximum flight speed (in m/s)").translation("config.powersuits.general.maxFlyingSpeed").defineInRange("maximumFlyingSpeedmps", 25.0, 0.0, 3.4028234663852886E38);
        this.GENERAL_BASE_MAX_HEAT_POWERFIST = builder.comment("PowerFistModel2 Base Heat Cap").translation("config.powersuits.general.maxHeatBasePowerFist").defineInRange("baseMaxHeatPowerFist", 5.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_HELMET = builder.comment("Power Armor Helmet Heat Cap").translation("config.powersuits.general.maxHeatBaseHelmet").defineInRange("baseMaxHeatHelmet", 5.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_CHEST = builder.comment("Power Armor Chestplate Heat Cap").translation("config.powersuits.general.maxHeatBaseChestplate").defineInRange("baseMaxHeatChest", 20.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_LEGS = builder.comment("Power Armor Leggings Heat Cap").translation("config.powersuits.general.maxHeatBaseLeggings").defineInRange("baseMaxHeatLegs", 15.0, 0.0, 5000.0);
        this.GENERAL_BASE_MAX_HEAT_FEET = builder.comment("Power Armor Boots Heat Cap").translation("config.powersuits.general.maxHeatBaseFeet").defineInRange("baseMaxHeatFeet", 5.0, 0.0, 5000.0);
        this.GENERAL_VEIN_MINER_ORE_LIST = builder.comment("Ore tag list for vein miner module.").translation("config.powersuits.general.maxVeinMinerOreList").worldRestart().defineList("veinMinerOres", Arrays.asList("forge:ores/iron", "forge:ores/copper", "forge:ores/tin", "forge:ores/lead", "forge:ores/aluminum", "forge:ores/aluminium", "forge:ores/silver", "forge:ores/gold", "forge:ores/cinnabar", "forge:ores/zinc", "forge:ores/uranium", "forge:ores/platinum", "forge:ores/bismuth", "forge:ores/osmium", "forge:ores/coal", "forge:ores/redstone", "minecraft:glowstone", "forge:ores/diamond", "forge:ores/lapis", "forge:ores/quartz"), o -> o instanceof String && !((String)o).isEmpty());
        this.GENERAL_VEIN_MINER_BLOCK_LIST = builder.comment("Block registry name whitelist for the vein miner module. \nUse for blocks that don't have an ore tag or to fine tune which blocks to break").translation("config.powersuits.general.maxVeinMinerBlockList").worldRestart().defineList("veinMinerBlocks", Collections.emptyList(), o -> o instanceof String && !((String)o).isEmpty());
        builder.pop();
        builder.comment("Model cosmetic settings").push("Cosmetic");
        this.COSMETIC_USE_LEGACY_COSMETIC_SYSTEM = builder.comment("Use legacy cosmetic configuration instead of cosmetic presets").translation("config.powersuits.cosmetic.useLegacyCosmeticSystem").worldRestart().define("useLegacyCosmeticSystem", true);
        this.COSMETIC_ALLOW_HIGH_POLLY_ARMOR_MODELS = builder.comment("Allow high polly armor models instead of just skins").translation("config.powersuits.cosmetic.allowHighPollyArmorModuels").define("allowHighPollyArmorModuels", true);
        this.COSMETIC_ALLOW_POWER_FIST_CUSTOMIZATOIN = builder.comment("Allow PowerFistModel2 model to be customized").translation("config.powersuits.cosmetic.allowPowerFistCustomization").define("allowPowerFistCustomization", true);
        builder.pop();
        builder.comment("Recipe settings").push("Recipes");
        this.RECIPES_USE_VANILLA = builder.comment("Use recipes for Vanilla").translation("config.powersuits.recipes.useVanilla").worldRestart().define("useVanillaRecipes", true);
        builder.pop();
    }
}

