/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.container;

import com.github.lehjr.numina.network.NuminaPackets;
import com.github.lehjr.numina.network.packets.CreativeInstallModuleRequestPacket;
import com.github.lehjr.numina.util.capabilities.inventory.modularitem.IModularItem;
import com.github.lehjr.numina.util.client.gui.slot.HideableSlot;
import com.github.lehjr.numina.util.client.gui.slot.HideableSlotItemHandler;
import com.github.lehjr.numina.util.client.gui.slot.IHideableSlot;
import com.github.lehjr.powersuits.basemod.MPSObjects;
import com.github.lehjr.powersuits.container.IModularItemToSlotMapProvider;
import com.github.lehjr.powersuits.network.MPSPackets;
import com.github.lehjr.powersuits.network.packets.MoveModuleFromSlotToSlotPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MPSWorkbenchContainer
extends Container
implements IModularItemToSlotMapProvider {
    private final PlayerEntity player;
    private Map<Integer, List<SlotItemHandler>> modularItemToSlotMap;

    public MPSWorkbenchContainer(int windowId, PlayerInventory playerInventory) {
        super((ContainerType)MPSObjects.MPS_WORKBENCH_CONTAINER_TYPE.get(), windowId);
        this.player = playerInventory.field_70458_d;
        this.modularItemToSlotMap = new HashMap<Integer, List<SlotItemHandler>>();
        for (int index = 0; index < playerInventory.func_70302_i_(); ++index) {
            this.func_75146_a((Slot)new HideableSlot((IInventory)playerInventory, index, 0, 0));
        }
        for (Slot slot : new ArrayList(this.field_75151_b)) {
            ArrayList slots = new ArrayList();
            slot.func_75211_c().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                if (iItemHandler instanceof IModularItem) {
                    for (int modularItemInvIndex = 0; modularItemInvIndex < iItemHandler.getSlots(); ++modularItemInvIndex) {
                        HideableSlotItemHandler slot1 = (HideableSlotItemHandler)this.func_75146_a((Slot)new HideableSlotItemHandler(iItemHandler, this.field_75151_b.indexOf(slot), modularItemInvIndex, -1000, -1000));
                        slots.add(slot1);
                    }
                }
            });
            if (slots.isEmpty()) continue;
            this.modularItemToSlotMap.put(slot.field_75222_d, slots);
        }
        for (Slot slot : this.field_75151_b) {
            if (!(slot instanceof IHideableSlot)) continue;
            ((IHideableSlot)slot).disable();
        }
    }

    public boolean func_94530_a(ItemStack itemStack, Slot slot) {
        if (slot instanceof SlotItemHandler) {
            return ((SlotItemHandler)slot).getItemHandler().isItemValid(slot.getSlotIndex(), itemStack);
        }
        return super.func_94530_a(itemStack, slot);
    }

    public boolean func_94531_b(Slot slotIn) {
        return false;
    }

    public boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack = slot.func_75211_c();
                if (!itemstack.func_190926_b() && MPSWorkbenchContainer.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_178170_b(stack), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_178170_b(stack)) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_75219_a()));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void creativeInstall(int slot, @Nonnull ItemStack itemStack) {
        if (this.func_75139_a(slot).func_178170_b(itemStack) > 0) {
            this.func_75141_a(slot, itemStack);
            NuminaPackets.CHANNEL_INSTANCE.sendToServer((Object)new CreativeInstallModuleRequestPacket(this.field_75152_c, slot, itemStack));
        }
    }

    public void move(int source, int target) {
        if (source == -1) {
            return;
        }
        if (target == -1) {
            return;
        }
        Slot sourceSlot = (Slot)this.field_75151_b.get(source);
        Slot targetSlot = (Slot)this.field_75151_b.get(target);
        ItemStack contents = sourceSlot.func_75211_c();
        ItemStack stackCopy = contents.func_77946_l();
        if (sourceSlot.func_82869_a(this.player) && this.func_94530_a(contents, targetSlot)) {
            targetSlot.func_75215_d(stackCopy);
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
            MPSPackets.CHANNEL_INSTANCE.sendToServer((Object)new MoveModuleFromSlotToSlotPacket(this.field_75152_c, source, target));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    @Override
    public Map<Integer, List<SlotItemHandler>> getModularItemToSlotMap() {
        return this.modularItemToSlotMap;
    }

    public Container getContainer() {
        return this;
    }
}

