/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.entity;

import com.github.lehjr.numina.util.math.Colour;
import com.github.lehjr.powersuits.basemod.MPSObjects;
import com.github.lehjr.powersuits.block.LuxCapacitorBlock;
import com.github.lehjr.powersuits.tile_entity.LuxCapacitorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class LuxCapacitorEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    public Colour color;

    public LuxCapacitorEntity(EntityType<? extends LuxCapacitorEntity> entityType, World world) {
        super(entityType, world);
        this.func_189654_d(true);
        if (this.color == null) {
            this.color = LuxCapacitorBlock.defaultColor;
        }
    }

    public LuxCapacitorEntity(World world, LivingEntity shootingEntity, Colour color) {
        super((EntityType)MPSObjects.LUX_CAPACITOR_ENTITY_TYPE.get(), shootingEntity, world);
        this.func_189654_d(true);
        this.color = color != null ? color : LuxCapacitorBlock.defaultColor;
        Vector3d direction = shootingEntity.func_70040_Z().func_72432_b();
        double speed = 1.0;
        this.func_213293_j(direction.field_72450_a * speed, direction.field_72448_b * speed, direction.field_72449_c * speed);
        double r = 0.4375;
        double xoffset = 0.1;
        double yoffset = 0.0;
        double zoffset = 0.0;
        double horzScale = Math.sqrt(direction.field_72450_a * direction.field_72450_a + direction.field_72449_c * direction.field_72449_c);
        double horzx = direction.field_72450_a / horzScale;
        double horzz = direction.field_72449_c / horzScale;
        this.func_70107_b(shootingEntity.func_226277_ct_() + direction.field_72450_a * xoffset - direction.field_72448_b * horzx * yoffset - horzz * zoffset, shootingEntity.func_226278_cu_() + (double)shootingEntity.func_70047_e() + direction.field_72448_b * xoffset + (1.0 - Math.abs(direction.field_72448_b)) * yoffset, shootingEntity.func_226281_cx_() + direction.field_72449_c * xoffset - direction.field_72448_b * horzz * yoffset + horzx * zoffset);
        this.func_174826_a(new AxisAlignedBB(this.func_226277_ct_() - r, this.func_226278_cu_() - 0.0625, this.func_226281_cx_() - r, this.func_226277_ct_() + r, this.func_226278_cu_() + 0.0625, this.func_226281_cx_() + r));
    }

    BlockState getBlockState(BlockPos pos, Direction facing) {
        FluidState ifluidstate = this.field_70170_p.func_204610_c(pos);
        return (BlockState)((BlockState)((LuxCapacitorBlock)MPSObjects.LUX_CAPACITOR_BLOCK.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)facing)).func_206870_a((Property)LuxCapacitorBlock.WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
    }

    protected void func_70227_a(RayTraceResult hitResult) {
        if (this.color == null) {
            this.color = LuxCapacitorBlock.defaultColor;
        }
        if (this.func_70089_S() && hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTrace = (BlockRayTraceResult)hitResult;
            Direction dir = blockRayTrace.func_216354_b().func_176734_d();
            int x = blockRayTrace.func_216350_a().func_177958_n() - dir.func_82601_c();
            int y = blockRayTrace.func_216350_a().func_177956_o() - dir.func_96559_d();
            int z = blockRayTrace.func_216350_a().func_177952_p() - dir.func_82599_e();
            if (y > 0) {
                BlockPos blockPos = new BlockPos(x, y, z);
                if (((LuxCapacitorBlock)MPSObjects.LUX_CAPACITOR_BLOCK.get()).func_176223_P().func_196955_c((IWorldReader)this.field_70170_p, blockPos)) {
                    BlockState blockState = this.getBlockState(blockPos, blockRayTrace.func_216354_b());
                    this.field_70170_p.func_175656_a(blockPos, blockState);
                    this.field_70170_p.func_175690_a(blockPos, (TileEntity)new LuxCapacitorTileEntity(this.color));
                } else {
                    for (Direction facing : Direction.values()) {
                        if (!((BlockState)((LuxCapacitorBlock)MPSObjects.LUX_CAPACITOR_BLOCK.get()).func_176223_P().func_206870_a((Property)LuxCapacitorBlock.field_176387_N, (Comparable)facing)).func_196955_c((IWorldReader)this.field_70170_p, blockPos)) continue;
                        BlockState blockState = this.getBlockState(blockPos, facing);
                        this.field_70170_p.func_175656_a(blockPos, blockState);
                        this.field_70170_p.func_175690_a(blockPos, (TileEntity)new LuxCapacitorTileEntity(this.color));
                        break;
                    }
                }
                this.func_70106_y();
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 400) {
            this.func_70106_y();
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.color.getInt());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.color = new Colour(additionalData.readInt());
    }
}

