/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.event;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class HarvestEventHandler {
    @SubscribeEvent
    public static void handleHarvestCheck(PlayerEvent.HarvestCheck event) {
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        BlockState state = event.getTargetBlock();
        if (state == null || state.func_177230_c() == null) {
            return;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
            if (iItemHandler instanceof IModeChangingItem) {
                if (!state.func_235783_q_()) {
                    event.setCanHarvest(true);
                    return;
                }
                RayTraceResult rayTraceResult = HarvestEventHandler.rayTrace(player.field_70170_p, player, RayTraceContext.FluidMode.SOURCE_ONLY);
                if (rayTraceResult == null || rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                    return;
                }
                BlockPos pos = new BlockPos(rayTraceResult.func_216347_e());
                if (pos == null) {
                    return;
                }
                int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                for (ItemStack module : ((IModeChangingItem)iItemHandler).getInstalledModulesOfType(IBlockBreakingModule.class)) {
                    if (!module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> pm instanceof IBlockBreakingModule && ((IBlockBreakingModule)pm).canHarvestBlock(stack, state, player, pos, playerEnergy)).orElse(false).booleanValue()) continue;
                    event.setCanHarvest(true);
                    return;
                }
            }
        });
    }

    protected static RayTraceResult rayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        Vector3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    @SubscribeEvent
    public static void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.field_71071_by.func_70448_g();
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
            BlockState state = event.getState();
            if (event.getNewSpeed() < event.getOriginalSpeed()) {
                event.setNewSpeed(event.getOriginalSpeed());
            }
            int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
            for (ItemStack module : ((IModeChangingItem)iItemHandler).getInstalledModulesOfType(IBlockBreakingModule.class)) {
                module.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(pm -> {
                    if (pm instanceof IBlockBreakingModule && ((IBlockBreakingModule)pm).canHarvestBlock(stack, state, player, event.getPos(), playerEnergy)) {
                        if (event.getNewSpeed() == 0.0f) {
                            event.setNewSpeed(1.0f);
                        }
                        ((IBlockBreakingModule)pm).handleBreakSpeed(event);
                    }
                });
            }
        });
    }
}

