/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.environmental;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class AutoFeederModule
extends AbstractPowerModule {
    public static final String TAG_FOOD = "Food";
    public static final String TAG_SATURATION = "Saturation";

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public static float getFoodLevel(@Nonnull ItemStack stack) {
        return MuseNBTUtils.getModuleFloatOrZero((ItemStack)stack, (String)TAG_FOOD);
    }

    public static void setFoodLevel(@Nonnull ItemStack stack, float saturation) {
        MuseNBTUtils.setModuleFloatOrRemove((ItemStack)stack, (String)TAG_FOOD, (float)saturation);
    }

    public static float getSaturationLevel(@Nonnull ItemStack stack) {
        return MuseNBTUtils.getModuleFloatOrZero((ItemStack)stack, (String)TAG_SATURATION);
    }

    public static void setSaturationLevel(@Nonnull ItemStack stack, float saturation) {
        MuseNBTUtils.setModuleFloatOrRemove((ItemStack)stack, (String)TAG_SATURATION, (float)saturation);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.ENVIRONMENTAL, EnumModuleTarget.HEADONLY, MPSSettings::getModuleConfig);
            this.ticker.addBaseProperty("energyConsumption", 100.0);
            this.ticker.addBaseProperty("autoFeederEfficiency", 50.0);
            this.ticker.addTradeoffProperty("efficiency", "energyConsumption", 1000.0, "FE");
            this.ticker.addTradeoffProperty("efficiency", "autoFeederEfficiency", 50.0);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap instanceof IToggleableModule) {
                ((IToggleableModule)cap).updateFromNBT();
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack itemX) {
                float foodLevel = AutoFeederModule.getFoodLevel(this.module);
                float saturationLevel = AutoFeederModule.getSaturationLevel(this.module);
                PlayerInventory inv = player.field_71071_by;
                double eatingEnergyConsumption = this.applyPropertyModifiers("energyConsumption");
                double efficiency = this.applyPropertyModifiers("autoFeederEfficiency");
                FoodStats foodStats = player.func_71024_bL();
                int foodNeeded = 20 - foodStats.func_75116_a();
                float saturationNeeded = 20.0f - foodStats.func_75115_e();
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (!stack.func_222117_E()) continue;
                    for (int a = 0; a < stack.func_190916_E(); ++a) {
                        foodLevel = (float)((double)foodLevel + (double)stack.func_77973_b().func_219967_s().func_221466_a() * efficiency / 100.0);
                        saturationLevel = (float)((double)saturationLevel + (double)Math.min((float)stack.func_77973_b().func_219967_s().func_221466_a() * stack.func_77973_b().func_219967_s().func_221469_b() * 2.0f, 20.0f) * efficiency / 100.0);
                    }
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                AutoFeederModule.setFoodLevel(this.module, foodLevel);
                AutoFeederModule.setSaturationLevel(this.module, saturationLevel);
                CompoundNBT foodStatNBT = new CompoundNBT();
                if (foodNeeded > 0 && AutoFeederModule.getFoodLevel(this.module) >= 1.0f) {
                    int foodUsed = 0;
                    if (AutoFeederModule.getFoodLevel(this.module) >= (float)foodNeeded && (double)foodNeeded * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                        foodUsed = foodNeeded;
                    } else if ((float)foodNeeded - AutoFeederModule.getFoodLevel(this.module) > 0.0f && (double)AutoFeederModule.getFoodLevel(this.module) * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                        foodUsed = (int)AutoFeederModule.getFoodLevel(this.module);
                    } else if (eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player) && AutoFeederModule.getFoodLevel(this.module) >= 1.0f) {
                        foodUsed = 1;
                    }
                    if (foodUsed > 0) {
                        foodStats.func_75117_b(foodStatNBT);
                        foodStatNBT.func_74768_a("foodLevel", foodStatNBT.func_74762_e("foodLevel") + foodUsed);
                        foodStats.func_75112_a(foodStatNBT);
                        AutoFeederModule.setFoodLevel(this.module, AutoFeederModule.getFoodLevel(this.module) - (float)foodUsed);
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(eatingEnergyConsumption * 0.5 * (double)foodUsed)));
                        if ((double)saturationNeeded >= 1.0) {
                            int saturationUsed = 0;
                            if (AutoFeederModule.getSaturationLevel(this.module) >= saturationNeeded && (double)saturationNeeded * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                                saturationUsed = (int)saturationNeeded;
                            } else if (saturationNeeded - AutoFeederModule.getSaturationLevel(this.module) > 0.0f && (double)AutoFeederModule.getSaturationLevel(this.module) * eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                                saturationUsed = (int)AutoFeederModule.getSaturationLevel(this.module);
                            } else if (eatingEnergyConsumption * 0.5 < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player) && AutoFeederModule.getSaturationLevel(this.module) >= 1.0f) {
                                saturationUsed = 1;
                            }
                            if (saturationUsed > 0) {
                                foodStats.func_75117_b(foodStatNBT);
                                foodStatNBT.func_74776_a("foodSaturationLevel", foodStatNBT.func_74760_g("foodSaturationLevel") + (float)saturationUsed);
                                foodStats.func_75112_a(foodStatNBT);
                                AutoFeederModule.setSaturationLevel(this.module, AutoFeederModule.getSaturationLevel(this.module) - (float)saturationUsed);
                                ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(eatingEnergyConsumption * 0.5 * (double)saturationUsed)));
                            }
                        }
                    }
                }
            }
        }
    }
}

