/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.environmental;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class MobRepulsorModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.ENVIRONMENTAL, EnumModuleTarget.TORSOONLY, MPSSettings::getModuleConfig);
            this.ticker.addBaseProperty("energyConsumption", 2500.0, "FE");
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap instanceof IToggleableModule) {
                ((IToggleableModule)cap).updateFromNBT();
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack item) {
                int energyConsumption = (int)this.applyPropertyModifiers("energyConsumption");
                if (ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > energyConsumption) {
                    if (player.field_70170_p.func_82737_E() % 20L == 0L) {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)energyConsumption);
                    }
                    this.repulse(player.field_70170_p, player.func_233580_cy_());
                }
            }

            public void repulse(World world, BlockPos playerPos) {
                float distance = 5.0f;
                AxisAlignedBB area = new AxisAlignedBB(playerPos.func_177963_a((double)(-distance), (double)(-distance), (double)(-distance)), playerPos.func_177963_a((double)distance, (double)distance, (double)distance));
                for (Entity entity : world.func_217357_a(MobEntity.class, area)) {
                    this.push(entity, playerPos);
                }
                for (Entity entity : world.func_217357_a(ArrowEntity.class, area)) {
                    this.push(entity, playerPos);
                }
                for (Entity entity : world.func_217357_a(FireballEntity.class, area)) {
                    this.push(entity, playerPos);
                }
                for (Entity entity : world.func_217357_a(PotionEntity.class, area)) {
                    this.push(entity, playerPos);
                }
            }

            private void push(Entity entity, BlockPos playerPos) {
                if (!(entity instanceof PlayerEntity) && !(entity instanceof EnderDragonEntity)) {
                    BlockPos distance = playerPos.func_177973_b((Vector3i)entity.func_233580_cy_());
                    double dX = distance.func_177958_n();
                    double dY = distance.func_177956_o();
                    double dZ = distance.func_177952_p();
                    double d4 = dX * dX + dY * dY + dZ * dZ;
                    if ((d4 *= d4) <= Math.pow(6.0, 4.0)) {
                        double d5 = -(dX * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                        double d6 = -(dY * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                        double d7 = -(dZ * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                        if (d5 > 0.0) {
                            d5 = 0.22;
                        } else if (d5 < 0.0) {
                            d5 = -0.22;
                        }
                        if (d6 > 0.2) {
                            d6 = 0.12;
                        } else if (d6 < -0.1) {
                            d6 = 0.12;
                        }
                        if (d7 > 0.0) {
                            d7 = 0.22;
                        } else if (d7 < 0.0) {
                            d7 = -0.22;
                        }
                        Vector3d motion = entity.func_213322_ci();
                        entity.func_213293_j(motion.field_72450_a + d5, motion.field_72448_b + d6, motion.field_72449_c + d7);
                    }
                }
            }
        }
    }
}

