/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.miningenhancement;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.IMiningEnhancementModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.MiningEnhancement;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class AOEPickUpgradeModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IMiningEnhancementModule miningEnhancement;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new Enhancement(module, EnumModuleCategory.MINING_ENHANCEMENT, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.miningEnhancement.addBaseProperty("energyConsumption", 500.0, "FE");
            this.miningEnhancement.addTradeoffProperty("diameter", "energyConsumption", 9500.0);
            this.miningEnhancement.addIntTradeoffProperty("diameter", "aoeMiningDiameter", 5, "m", 2, 1);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.miningEnhancement));
        }

        class Enhancement
        extends MiningEnhancement {
            public Enhancement(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean onBlockStartBreak(ItemStack itemStack, BlockPos posIn, PlayerEntity player) {
                Stream posList;
                if (player.field_70170_p.field_72995_K) {
                    return false;
                }
                AtomicBoolean harvested = new AtomicBoolean(false);
                BlockRayTraceResult rayTraceResult = AOEPickUpgradeModule.func_219968_a((World)player.field_70170_p, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
                if (rayTraceResult == null || rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                    return false;
                }
                int radius = (int)(this.applyPropertyModifiers("aoeMiningDiameter") - 1.0) / 2;
                if (radius == 0) {
                    return false;
                }
                Direction side = rayTraceResult.func_216354_b();
                switch (side) {
                    case UP: 
                    case DOWN: {
                        posList = BlockPos.func_218281_b((BlockPos)posIn.func_177964_d(radius).func_177985_f(radius), (BlockPos)posIn.func_177970_e(radius).func_177965_g(radius));
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        posList = BlockPos.func_218281_b((BlockPos)posIn.func_177981_b(radius).func_177964_d(radius), (BlockPos)posIn.func_177979_c(radius).func_177970_e(radius));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        posList = BlockPos.func_218281_b((BlockPos)posIn.func_177981_b(radius).func_177985_f(radius), (BlockPos)posIn.func_177979_c(radius).func_177965_g(radius));
                        break;
                    }
                    default: {
                        posList = new ArrayList().stream();
                    }
                }
                int energyUsage = this.getEnergyUsage();
                AtomicInteger blocksBroken = new AtomicInteger(0);
                posList.forEach(blockPos -> {
                    BlockState state = player.field_70170_p.func_180495_p(blockPos);
                    int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                    itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(modeChanging -> {
                        if (modeChanging instanceof IModeChangingItem) {
                            for (ItemStack blockBreakingModule : ((IModeChangingItem)modeChanging).getInstalledModulesOfType(IBlockBreakingModule.class)) {
                                if (!blockBreakingModule.getCapability(PowerModuleCapability.POWER_MODULE).map(b -> {
                                    if (b instanceof IBlockBreakingModule && ((IBlockBreakingModule)b).canHarvestBlock(itemStack, state, player, blockPos, playerEnergy - energyUsage)) {
                                        return true;
                                    }
                                    return false;
                                }).orElse(false).booleanValue()) continue;
                                if (posIn == blockPos) {
                                    harvested.set(true);
                                }
                                blocksBroken.getAndAdd(1);
                                Block.func_196263_a((BlockState)state, (BlockState)Blocks.field_150350_a.func_176223_P(), (IWorld)player.field_70170_p, (BlockPos)blockPos, (int)3);
                                ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)(blockBreakingModule.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
                                    if (m instanceof IBlockBreakingModule) {
                                        return ((IBlockBreakingModule)m).getEnergyUsage();
                                    }
                                    return 0;
                                }).orElse(0) + energyUsage));
                                break;
                            }
                        }
                    });
                });
                return harvested.get();
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("energyConsumption");
            }
        }
    }
}

