/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.miningenhancement;

import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.MiningEnhancement;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AquaAffinityModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        MiningEnhancement miningEnhancement;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new BlockBreaker(module, EnumModuleCategory.MINING_ENHANCEMENT, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.miningEnhancement.addBaseProperty("energyConsumption", 0.0, "FE");
            this.miningEnhancement.addBaseProperty("harvSpeed", (double)0.2f, "%");
            this.miningEnhancement.addTradeoffProperty("power", "energyConsumption", 1000.0);
            this.miningEnhancement.addTradeoffProperty("power", "harvSpeed", (double)0.8f);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.miningEnhancement));
        }

        class BlockBreaker
        extends MiningEnhancement
        implements IBlockBreakingModule {
            public BlockBreaker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean canHarvestBlock(@Nonnull ItemStack stack, BlockState state, PlayerEntity player, BlockPos pos, int playerEnergy) {
                return false;
            }

            public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving, int playerEnergy) {
                if (this.canHarvestBlock(itemStack, state, (PlayerEntity)entityLiving, pos, playerEnergy)) {
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)((PlayerEntity)entityLiving), (int)this.getEnergyUsage());
                    return true;
                }
                return false;
            }

            public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
                PlayerEntity player = event.getPlayer();
                if (event.getNewSpeed() > 1.0f && (player.func_204231_K() || !player.func_233570_aj_()) && ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > this.getEnergyUsage()) {
                    event.setNewSpeed((float)((double)(event.getNewSpeed() * 5.0f) * this.applyPropertyModifiers("harvSpeed")));
                }
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("energyConsumption");
            }

            @Nonnull
            public ItemStack getEmulatedTool() {
                return ItemStack.field_190927_a;
            }
        }
    }
}

