/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.miningenhancement;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.IMiningEnhancementModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.MiningEnhancement;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class VeinMinerModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IMiningEnhancementModule miningEnhancement;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.miningEnhancement = new Enhancement(module, EnumModuleCategory.MINING_ENHANCEMENT, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.miningEnhancement.addBaseProperty("energyConsumption", 500.0, "FE");
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.miningEnhancement));
        }

        class Enhancement
        extends MiningEnhancement {
            public Enhancement(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            List<BlockPos> getPosList(Block block, final BlockPos startPos, World world) {
                ArrayList<BlockPos> list = new ArrayList<BlockPos>(){
                    {
                        this.add(startPos);
                    }
                };
                for (Direction direction : Direction.values()) {
                    BlockPos pos2;
                    for (int i = 0; i < 1000 && (pos2 = startPos.func_177967_a(direction, i)).func_177956_o() < world.func_217301_I() && pos2.func_177956_o() > 0 && world.func_180495_p(pos2).func_177230_c() == block; ++i) {
                        if (list.contains(pos2)) continue;
                        list.add(pos2);
                    }
                }
                return list;
            }

            void harvestBlocks(List<BlockPos> posList, World world) {
                for (BlockPos pos : posList) {
                    Block.func_196263_a((BlockState)world.func_180495_p(pos), (BlockState)Blocks.field_150350_a.func_176223_P(), (IWorld)world, (BlockPos)pos, (int)3);
                }
            }

            public boolean onBlockStartBreak(ItemStack itemStack, final BlockPos posIn, PlayerEntity player) {
                BlockState state = player.field_70170_p.func_180495_p(posIn);
                Block block = state.func_177230_c();
                if (block == Blocks.field_150348_b || block == Blocks.field_150350_a) {
                    return false;
                }
                int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                int energyUsage = this.getEnergyUsage();
                AtomicInteger bbModuleEnergyUsage = new AtomicInteger(0);
                itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(modeChanging -> {
                    block1: {
                        ItemStack blockBreakingModule;
                        if (!(modeChanging instanceof IModeChangingItem)) break block1;
                        Iterator iterator = ((IModeChangingItem)modeChanging).getInstalledModulesOfType(IBlockBreakingModule.class).iterator();
                        while (iterator.hasNext() && !(blockBreakingModule = (ItemStack)iterator.next()).getCapability(PowerModuleCapability.POWER_MODULE).map(b -> {
                            if (b instanceof IBlockBreakingModule && ((IBlockBreakingModule)b).canHarvestBlock(itemStack, state, player, posIn, playerEnergy - energyUsage)) {
                                bbModuleEnergyUsage.addAndGet(((IBlockBreakingModule)b).getEnergyUsage());
                                return true;
                            }
                            return false;
                        }).orElse(false).booleanValue()) {
                        }
                    }
                });
                List<ResourceLocation> defaultOreTags = MPSSettings.getOreList();
                Set oretags = player.field_70170_p.func_180495_p(posIn).func_177230_c().getTags();
                boolean isOre = false;
                for (ResourceLocation location : oretags) {
                    if (!defaultOreTags.contains(location)) continue;
                    isOre = true;
                    break;
                }
                if (isOre || MPSSettings.getBlockList().contains(block.getRegistryName())) {
                    int energyRequired = this.getEnergyUsage() + bbModuleEnergyUsage.get();
                    if (playerEnergy < energyRequired) {
                        return false;
                    }
                    ArrayList<BlockPos> posList = this.getPosList(block, posIn, player.field_70170_p);
                    ArrayList<BlockPos> posListCopy = new ArrayList<BlockPos>(posList);
                    int size = 0;
                    int newSize = posListCopy.size();
                    if (newSize == 1) {
                        return false;
                    }
                    if (newSize * energyRequired > playerEnergy) {
                        posList = new ArrayList<BlockPos>(){
                            {
                                this.add(posIn);
                            }
                        };
                        posListCopy.remove(posIn);
                        for (BlockPos pos : posListCopy) {
                            if ((posList.size() + 1) * energyRequired <= playerEnergy) {
                                posList.add(pos);
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (int i = 0; i < 100 && size != newSize; ++i) {
                            size = posListCopy.size();
                            block3: for (BlockPos pos : posListCopy) {
                                List<BlockPos> posList2 = this.getPosList(block, pos, player.field_70170_p);
                                for (BlockPos pos2 : posList2) {
                                    if (posList.contains(pos2)) continue;
                                    if ((posList.size() + 1) * energyRequired > playerEnergy) {
                                        i = 1000;
                                        break block3;
                                    }
                                    posList.add(pos2);
                                }
                            }
                            newSize = posList.size();
                            posListCopy = new ArrayList<BlockPos>(posList);
                        }
                    }
                    if (!player.field_70170_p.func_201670_d()) {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)(energyRequired * posList.size()));
                    }
                    this.harvestBlocks((List<BlockPos>)posList, player.field_70170_p);
                }
                return false;
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("energyConsumption");
            }
        }
    }
}

