/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.movement;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.heat.MuseHeatUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;

public class DimensionalRiftModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    private static class CommandTeleporter
    implements ITeleporter {
        private final BlockPos targetPos;

        private CommandTeleporter(BlockPos targetPos) {
            this.targetPos = targetPos;
        }

        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            entity.func_174828_a(this.targetPos, yaw, entity.field_70125_A);
            return repositionEntity.apply(false);
        }
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IRightClickModule rightClick;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClick = new RightClickie(module, EnumModuleCategory.MOVEMENT, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.rightClick.addBaseProperty("heatGen", 55.0);
            this.rightClick.addBaseProperty("energyConsumption", 200000.0);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.rightClick));
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                if (!playerIn.func_184218_aH() && !playerIn.func_184207_aI() && playerIn.func_184222_aU() && !playerIn.field_70170_p.func_201670_d()) {
                    BlockPos coords;
                    BlockPos blockPos = coords = playerIn.func_213374_dv().isPresent() ? (BlockPos)playerIn.func_213374_dv().get() : ((ServerWorld)playerIn.field_70170_p).func_241135_u_();
                    while (!worldIn.func_175623_d(coords) && !worldIn.func_175623_d(coords.func_177984_a())) {
                        coords = coords.func_177984_a();
                    }
                    int energyConsumption = (int)this.applyPropertyModifiers("energyConsumption");
                    int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn);
                    if (playerEnergy >= energyConsumption) {
                        playerIn.changeDimension((ServerWorld)worldIn, (ITeleporter)new CommandTeleporter(coords));
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, (int)this.getEnergyUsage());
                        MuseHeatUtils.heatPlayer((LivingEntity)playerIn, (double)this.applyPropertyModifiers("heatGen"));
                        return ActionResult.func_226248_a_((Object)itemStackIn);
                    }
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("energyConsumption");
            }
        }
    }
}

