/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.movement;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.event.MovementManager;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class SprintAssistModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.MOVEMENT, EnumModuleTarget.LEGSONLY, MPSSettings::getModuleConfig);
            this.ticker.addBaseProperty("sprintEnergyCon", 0.0, "FE");
            this.ticker.addTradeoffProperty("sprintAssist", "sprintEnergyCon", 100.0);
            this.ticker.addBaseProperty("sprintSpeedMult", (double)0.01f, "%");
            this.ticker.addTradeoffProperty("sprintAssist", "sprintSpeedMult", (double)2.49f);
            this.ticker.addBaseProperty("sprintEnergyCon", 0.0, "FE");
            this.ticker.addTradeoffProperty("compensation", "sprintEnergyCon", 20.0);
            this.ticker.addBaseProperty("sprintExComp", 0.0, "%");
            this.ticker.addTradeoffProperty("compensation", "sprintExComp", 1.0);
            this.ticker.addBaseProperty("walkingEnergyCon", 0.0, "FE");
            this.ticker.addTradeoffProperty("walkingAssist", "walkingEnergyCon", 100.0);
            this.ticker.addBaseProperty("walkingSpeedMult", (double)0.01f, "%");
            this.ticker.addTradeoffProperty("walkingAssist", "walkingSpeedMult", (double)1.99f);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap instanceof IPlayerTickModule) {
                this.ticker.updateFromNBT();
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack itemStack) {
                if (player.field_71075_bZ.field_75100_b || player.func_184218_aH() || player.func_184613_cA()) {
                    this.onPlayerTickInactive(player, itemStack);
                }
                double horzMovement = player.field_70140_Q - player.field_70141_P;
                double totalEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)player);
                if (horzMovement > 0.0) {
                    if (player.func_70051_ag()) {
                        double exhaustion = (double)Math.round(horzMovement * 100.0) * 0.01;
                        double sprintCost = this.applyPropertyModifiers("sprintEnergyCon");
                        if (sprintCost < totalEnergy) {
                            double sprintMultiplier = this.applyPropertyModifiers("sprintSpeedMult");
                            double exhaustionComp = this.applyPropertyModifiers("sprintExComp");
                            ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(sprintCost * horzMovement * 5.0)));
                            MovementManager.INSTANCE.setMovementModifier(itemStack, sprintMultiplier, player);
                            player.func_71024_bL().func_75113_a((float)(-0.01 * exhaustion * exhaustionComp));
                            player.field_70747_aH = player.func_70689_ay() * 0.2f;
                        }
                    } else {
                        double cost = this.applyPropertyModifiers("walkingEnergyCon");
                        if (cost < totalEnergy) {
                            double walkMultiplier = this.applyPropertyModifiers("walkingSpeedMult");
                            ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)(cost * horzMovement * 5.0)));
                            MovementManager.INSTANCE.setMovementModifier(itemStack, walkMultiplier, player);
                            player.field_70747_aH = player.func_70689_ay() * 0.2f;
                        }
                    }
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, @Nonnull ItemStack itemStack) {
                MovementManager.INSTANCE.setMovementModifier(itemStack, 0.0, player);
            }
        }
    }
}

