/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.movement;

import com.github.lehjr.numina.client.control.PlayerMovementInputWrapper;
import com.github.lehjr.numina.config.NuminaSettings;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.toggleable.IToggleableModule;
import com.github.lehjr.numina.util.client.sound.Musique;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.client.sound.MPSSoundDictionary;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.event.MovementManager;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class SwimAssistModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.MOVEMENT, EnumModuleTarget.LEGSONLY, MPSSettings::getModuleConfig);
            this.ticker.addTradeoffProperty("thrust", "energyConsumption", 1000.0, "FE");
            this.ticker.addTradeoffProperty("thrust", "underwaterMovBoost", 1.0, "m/s");
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap instanceof IToggleableModule) {
                ((IToggleableModule)cap).updateFromNBT();
            }
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, false);
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack item) {
                if (player.func_70090_H() && !player.func_184218_aH()) {
                    PlayerMovementInputWrapper.PlayerMovementInput playerInput = PlayerMovementInputWrapper.get((PlayerEntity)player);
                    if (playerInput.moveForward != 0.0f || playerInput.moveStrafe != 0.0f || playerInput.jumpKey || playerInput.sneakKey) {
                        double moveRatio = 0.0;
                        if (playerInput.moveForward != 0.0f) {
                            moveRatio += (double)(playerInput.moveForward * playerInput.moveForward);
                        }
                        if (playerInput.moveStrafe != 0.0f) {
                            moveRatio += (double)(playerInput.moveStrafe * playerInput.moveStrafe);
                        }
                        if (playerInput.jumpKey || playerInput.sneakKey) {
                            moveRatio += 0.04000000000000001;
                        }
                        double swimAssistRate = this.applyPropertyModifiers("underwaterMovBoost") * 0.05 * moveRatio;
                        double swimEnergyConsumption = this.applyPropertyModifiers("energyConsumption");
                        if (swimEnergyConsumption < (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player)) {
                            if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                                Musique.playerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.SWIM_ASSIST, (SoundCategory)SoundCategory.PLAYERS, (float)1.0f, (Float)Float.valueOf(1.0f), (Boolean)true);
                            }
                            MovementManager.INSTANCE.thrust(player, swimAssistRate, true);
                        } else if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                            Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.SWIM_ASSIST);
                        }
                    } else if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                        Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.SWIM_ASSIST);
                    }
                } else if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.SWIM_ASSIST);
                }
            }

            public void onPlayerTickInactive(PlayerEntity player, ItemStack item) {
                if (player.field_70170_p.field_72995_K && NuminaSettings.useSounds()) {
                    Musique.stopPlayerSound((PlayerEntity)player, (SoundEvent)MPSSoundDictionary.SWIM_ASSIST);
                }
            }
        }
    }
}

