/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.tool;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.helper.ToolHelpers;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.items.CapabilityItemHandler;

public class DiamondPickUpgradeModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IBlockBreakingModule blockBreaking;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.blockBreaking = new BlockBreaker(module, EnumModuleCategory.TOOL, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.blockBreaking.addBaseProperty("energyConsumption", 500.0, "FE");
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.blockBreaking));
        }

        class BlockBreaker
        extends PowerModule
        implements IBlockBreakingModule {
            public BlockBreaker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean canHarvestBlock(@Nonnull ItemStack powerFist, BlockState state, PlayerEntity player, BlockPos pos, int playerEnergy) {
                AtomicBoolean canHarvest = new AtomicBoolean(false);
                powerFist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(modeChanging -> {
                    ItemStack pickaxeModule;
                    if (modeChanging instanceof IModeChangingItem && !(pickaxeModule = ((IModeChangingItem)modeChanging).getOnlineModuleOrEmpty(MPSRegistryNames.PICKAXE_MODULE_REGNAME)).func_190926_b()) {
                        int energyUsage = pickaxeModule.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
                            if (m instanceof IBlockBreakingModule) {
                                return ((IBlockBreakingModule)m).getEnergyUsage();
                            }
                            return 0;
                        }).orElse(0);
                        canHarvest.set(pickaxeModule.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
                            if (m instanceof IBlockBreakingModule) {
                                return !((IBlockBreakingModule)m).canHarvestBlock(powerFist, state, player, pos, playerEnergy) && playerEnergy >= energyUsage && ToolHelpers.isToolEffective((IBlockReader)player.func_130014_f_(), (BlockPos)pos, (ItemStack)this.getEmulatedTool());
                            }
                            return false;
                        }).orElse(false));
                    }
                });
                return canHarvest.get();
            }

            public boolean onBlockDestroyed(ItemStack powerFist, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving, int playerEnergy) {
                if (this.canHarvestBlock(powerFist, state, (PlayerEntity)entityLiving, pos, playerEnergy)) {
                    AtomicInteger energyUsage = new AtomicInteger(0);
                    powerFist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(modeChanging -> {
                        ItemStack pickaxeModule;
                        if (modeChanging instanceof IModeChangingItem && !(pickaxeModule = ((IModeChangingItem)modeChanging).getOnlineModuleOrEmpty(MPSRegistryNames.PICKAXE_MODULE_REGNAME)).func_190926_b()) {
                            energyUsage.set(pickaxeModule.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
                                if (m instanceof IBlockBreakingModule) {
                                    return ((IBlockBreakingModule)m).getEnergyUsage();
                                }
                                return 0;
                            }).orElse(0));
                        }
                    });
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)((PlayerEntity)entityLiving), (int)energyUsage.get());
                    return true;
                }
                return false;
            }

            public ItemStack getEmulatedTool() {
                return new ItemStack((IItemProvider)Items.field_151046_w);
            }

            public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
                PlayerEntity player = event.getPlayer();
                ItemStack powerFist = player.func_184614_ca();
                AtomicDouble newSpeed = new AtomicDouble((double)event.getNewSpeed());
                powerFist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(modeChanging -> {
                    ItemStack pickaxeModule;
                    if (modeChanging instanceof IModeChangingItem && !(pickaxeModule = ((IModeChangingItem)modeChanging).getOnlineModuleOrEmpty(MPSRegistryNames.PICKAXE_MODULE_REGNAME)).func_190926_b()) {
                        newSpeed.set(newSpeed.get() * pickaxeModule.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> m.applyPropertyModifiers("harvSpeed")).orElse(1.0));
                    }
                });
                event.setNewSpeed((float)newSpeed.get());
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("energyConsumption");
            }
        }
    }
}

