/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.tool;

import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShearsModule
extends AbstractPowerModule {
    static final ArrayList<Material> materials = new ArrayList<Material>(){
        {
            this.add(Material.field_151585_k);
            this.add(Material.field_203243_f);
            this.add(Material.field_151582_l);
            this.add(Material.field_204868_h);
            this.add(Material.field_151569_G);
            this.add(Material.field_151580_n);
            this.add(Material.field_151584_j);
        }
    };

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IRightClickModule rightClick;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClick = new BlockBreaker(module, EnumModuleCategory.TOOL, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.rightClick.addBaseProperty("energyConsumption", 1000.0, "FE");
            this.rightClick.addBaseProperty("harvSpeed", 8.0, "x");
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.rightClick));
        }

        class BlockBreaker
        extends RightClickModule
        implements IBlockBreakingModule {
            public BlockBreaker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving, int playerEnergy) {
                IForgeShearable target;
                if (entityLiving.field_70170_p.func_201670_d()) {
                    return false;
                }
                Block block = state.func_177230_c();
                if (block instanceof IForgeShearable && ElectricItemUtils.getPlayerEnergy((LivingEntity)((PlayerEntity)entityLiving)) > this.getEnergyUsage() && (target = (IForgeShearable)block).isShearable(itemStack, entityLiving.field_70170_p, pos)) {
                    List drops = target.onSheared((PlayerEntity)entityLiving, itemStack, entityLiving.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack));
                    Random rand = new Random();
                    for (ItemStack stack : drops) {
                        float f = 0.7f;
                        double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        ItemEntity entityitem = new ItemEntity(entityLiving.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                        entityitem.func_174869_p();
                        entityitem.field_70170_p.func_217376_c((Entity)entityitem);
                    }
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)((PlayerEntity)entityLiving), (int)this.getEnergyUsage());
                    ((PlayerEntity)entityLiving).func_195066_a(block.getRegistryName());
                    return true;
                }
                return false;
            }

            public ItemStack getEmulatedTool() {
                return new ItemStack((IItemProvider)Items.field_151097_aZ);
            }

            public int getEnergyUsage() {
                return (int)this.applyPropertyModifiers("energyConsumption");
            }

            public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
                event.setNewSpeed((float)((double)event.getNewSpeed() * this.applyPropertyModifiers("harvSpeed")));
            }

            public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                Entity entity;
                IForgeShearable target;
                if (playerIn.field_70170_p.field_72995_K) {
                    return ActionResult.func_226250_c_((Object)itemStackIn);
                }
                BlockRayTraceResult rayTraceResult = ShearsModule.func_219968_a((World)playerIn.field_70170_p, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
                if (rayTraceResult != null && rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof IForgeShearable && (target = (IForgeShearable)((EntityRayTraceResult)rayTraceResult).func_216348_a()).isShearable(itemStackIn, entity.field_70170_p, (entity = ((EntityRayTraceResult)rayTraceResult).func_216348_a()).func_233580_cy_())) {
                    List drops = target.onSheared(playerIn, itemStackIn, entity.field_70170_p, entity.func_233580_cy_(), 0);
                    Random rand = new Random();
                    for (ItemStack drop : drops) {
                        ItemEntity ent = entity.func_70099_a(drop, 1.0f);
                        Vector3d motion = ent.func_213322_ci();
                        ent.func_213293_j(motion.field_72450_a + (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), motion.field_72448_b + (double)(rand.nextFloat() * 0.05f), motion.field_72449_c + (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f));
                    }
                    ElectricItemUtils.drainPlayerEnergy((LivingEntity)playerIn, (int)this.getEnergyUsage());
                    return ActionResult.func_226248_a_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }
        }
    }
}

