/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.weapon;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.rightclick.RightClickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.entity.SpinningBladeEntity;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class BladeLauncherModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IRightClickModule rightClickie;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.rightClickie = new RightClickie(module, EnumModuleCategory.WEAPON, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.rightClickie.addBaseProperty("spinBladeEnergyCon", 5000.0, "FE");
            this.rightClickie.addBaseProperty("spinBladeDam", 6.0, "pt");
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.rightClickie));
        }

        class RightClickie
        extends RightClickModule {
            public RightClickie(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config);
            }

            public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                if (hand == Hand.MAIN_HAND && (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn) > this.applyPropertyModifiers("spinBladeEnergyCon")) {
                    playerIn.func_184598_c(hand);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
                }
                return new ActionResult(ActionResultType.PASS, (Object)itemStackIn);
            }

            public void onPlayerStoppedUsing(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
                if (!worldIn.field_72995_K) {
                    int energyConsumption = this.getEnergyUsage();
                    if (ElectricItemUtils.getPlayerEnergy((LivingEntity)entityLiving) > energyConsumption) {
                        ElectricItemUtils.drainPlayerEnergy((LivingEntity)entityLiving, (int)energyConsumption);
                        SpinningBladeEntity blade = new SpinningBladeEntity(worldIn, entityLiving);
                        worldIn.func_217376_c((Entity)blade);
                    }
                }
            }

            public int getEnergyUsage() {
                return (int)Math.round(this.applyPropertyModifiers("spinBladeEnergyCon"));
            }
        }
    }
}

