/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.module.weapon;

import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleCategory;
import com.github.lehjr.numina.util.capabilities.module.powermodule.EnumModuleTarget;
import com.github.lehjr.numina.util.capabilities.module.powermodule.IConfig;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.IPlayerTickModule;
import com.github.lehjr.numina.util.capabilities.module.tickable.PlayerTickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.numina.util.heat.MuseHeatUtils;
import com.github.lehjr.numina.util.math.MuseMathUtils;
import com.github.lehjr.numina.util.nbt.MuseNBTUtils;
import com.github.lehjr.powersuits.config.MPSSettings;
import com.github.lehjr.powersuits.entity.RailgunBoltEntity;
import com.github.lehjr.powersuits.item.module.AbstractPowerModule;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class RailgunModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        IPlayerTickModule ticker;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, EnumModuleCategory.WEAPON, EnumModuleTarget.TOOLONLY, MPSSettings::getModuleConfig);
            this.ticker.addBaseProperty("railgunTotalImpulse", 500.0, "Ns");
            this.ticker.addBaseProperty("railgunEnergyCost", 5000.0, "FE");
            this.ticker.addBaseProperty("railgunHeatEm", 2.0, "");
            this.ticker.addTradeoffProperty("voltage", "railgunTotalImpulse", 2500.0);
            this.ticker.addTradeoffProperty("voltage", "railgunEnergyCost", 25000.0);
            this.ticker.addTradeoffProperty("voltage", "railgunHeatEm", 10.0);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return PowerModuleCapability.POWER_MODULE.orEmpty(cap, LazyOptional.of(() -> this.ticker));
        }

        class Ticker
        extends PlayerTickModule
        implements IRightClickModule {
            public Ticker(ItemStack module, EnumModuleCategory category, EnumModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public void onPlayerTickActive(PlayerEntity player, @Nonnull ItemStack itemStackIn) {
                double timer = MuseNBTUtils.getModularItemDoubleOrZero((ItemStack)itemStackIn, (String)"cooldown");
                if (timer > 0.0) {
                    MuseNBTUtils.setModularItemDoubleOrRemove((ItemStack)itemStackIn, (String)"cooldown", (double)(timer - 1.0 > 0.0 ? timer - 1.0 : 0.0));
                }
            }

            public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, PlayerEntity playerIn, Hand hand) {
                if (hand == Hand.MAIN_HAND && ElectricItemUtils.getPlayerEnergy((LivingEntity)playerIn) > this.getEnergyUsage()) {
                    playerIn.func_184598_c(hand);
                    return ActionResult.func_226248_a_((Object)itemStackIn);
                }
                return ActionResult.func_226250_c_((Object)itemStackIn);
            }

            public void onPlayerStoppedUsing(ItemStack itemStack, World worldIn, LivingEntity entityLiving, int timeLeft) {
                int chargeTicks = (int)MuseMathUtils.clampDouble((double)(itemStack.func_77988_m() - timeLeft), (double)10.0, (double)50.0);
                if (!worldIn.field_72995_K && entityLiving instanceof PlayerEntity) {
                    double chargePercent = (double)chargeTicks * 0.02;
                    double energyConsumption = (double)this.getEnergyUsage() * chargePercent;
                    double timer = MuseNBTUtils.getModularItemDoubleOrZero((ItemStack)itemStack, (String)"cooldown");
                    if (!worldIn.field_72995_K && (double)ElectricItemUtils.getPlayerEnergy((LivingEntity)entityLiving) > energyConsumption && timer == 0.0) {
                        MuseNBTUtils.setModularItemDoubleOrRemove((ItemStack)itemStack, (String)"cooldown", (double)10.0);
                        PlayerEntity playerentity = (PlayerEntity)entityLiving;
                        double velocity = this.applyPropertyModifiers("railgunTotalImpulse") * chargePercent;
                        double damage = velocity * 0.01;
                        double knockback = damage * 0.05;
                        RailgunBoltEntity bolt = new RailgunBoltEntity(worldIn, entityLiving, velocity, chargePercent, damage, knockback);
                        if (worldIn.func_217376_c((Entity)bolt)) {
                            Vector3d lookVec = playerentity.func_70040_Z();
                            worldIn.func_184148_a(null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            ElectricItemUtils.drainPlayerEnergy((LivingEntity)entityLiving, (int)((int)energyConsumption));
                            MuseHeatUtils.heatPlayer((LivingEntity)entityLiving, (double)(this.applyPropertyModifiers("railgunHeatEm") * chargePercent));
                            entityLiving.func_70024_g(-lookVec.field_72450_a * knockback, Math.abs(-lookVec.field_72448_b + (double)0.2f) * knockback, -lookVec.field_72449_c * knockback);
                        } else {
                            System.out.println("bolt not added");
                        }
                    }
                }
            }

            public int getEnergyUsage() {
                return (int)Math.round(this.applyPropertyModifiers("railgunEnergyCost"));
            }
        }
    }
}

