/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.item.tool;

import com.github.lehjr.numina.util.capabilities.inventory.modechanging.IModeChangingItem;
import com.github.lehjr.numina.util.capabilities.module.blockbreaking.IBlockBreakingModule;
import com.github.lehjr.numina.util.capabilities.module.miningenhancement.IMiningEnhancementModule;
import com.github.lehjr.numina.util.capabilities.module.powermodule.PowerModuleCapability;
import com.github.lehjr.numina.util.capabilities.module.rightclick.IRightClickModule;
import com.github.lehjr.numina.util.energy.ElectricItemUtils;
import com.github.lehjr.powersuits.basemod.MPSObjects;
import com.github.lehjr.powersuits.constants.MPSRegistryNames;
import com.github.lehjr.powersuits.item.tool.AbstractElectricTool;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.CapabilityItemHandler;

public class PowerFist
extends AbstractElectricTool {
    public PowerFist() {
        super(new Item.Properties().func_200916_a((ItemGroup)MPSObjects.creativeTab).func_200917_a(1).func_200915_b(0));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean func_179218_a(ItemStack powerFist, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        int playerEnergy = ElectricItemUtils.getPlayerEnergy((LivingEntity)entityLiving);
        return powerFist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            if (iItemHandler instanceof IModeChangingItem) {
                for (ItemStack module : ((IModeChangingItem)iItemHandler).getInstalledModulesOfType(IBlockBreakingModule.class)) {
                    if (!module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> {
                        if (pm instanceof IBlockBreakingModule) {
                            return ((IBlockBreakingModule)pm).onBlockDestroyed(powerFist, worldIn, state, pos, entityLiving, playerEnergy);
                        }
                        return false;
                    }).orElse(false).booleanValue()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }).orElse(false);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public Set<ToolType> getToolTypes(ItemStack itemStack) {
        return itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            HashSet<ToolType> retSet = new HashSet<ToolType>();
            if (iItemHandler instanceof IModeChangingItem) {
                if (!((IModeChangingItem)iItemHandler).getOnlineModuleOrEmpty(MPSRegistryNames.PICKAXE_MODULE_REGNAME).func_190926_b()) {
                    retSet.add(ToolType.PICKAXE);
                }
                if (!((IModeChangingItem)iItemHandler).getOnlineModuleOrEmpty(MPSRegistryNames.AXE_MODULE_REGNAME).func_190926_b()) {
                    retSet.add(ToolType.AXE);
                }
                if (!((IModeChangingItem)iItemHandler).getOnlineModuleOrEmpty(MPSRegistryNames.SHOVEL_MODULE_REGNAME).func_190926_b()) {
                    retSet.add(ToolType.SHOVEL);
                }
            }
            return retSet;
        }).orElse(new HashSet());
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity) {
            itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(iItemHandler -> {
                if (iItemHandler instanceof IModeChangingItem) {
                    ((IModeChangingItem)iItemHandler).getOnlineModuleOrEmpty(MPSRegistryNames.MELEE_ASSIST_MODULE_REGNAME).getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(pm -> {
                        PlayerEntity player = (PlayerEntity)attacker;
                        double drain = pm.applyPropertyModifiers("punchEnergyCon");
                        if ((double)ElectricItemUtils.getPlayerEnergy((LivingEntity)player) > drain) {
                            ElectricItemUtils.drainPlayerEnergy((LivingEntity)player, (int)((int)drain));
                            double damage = pm.applyPropertyModifiers("meleeDamage");
                            double knockback = pm.applyPropertyModifiers("meleeKnockback");
                            DamageSource damageSource = DamageSource.func_76365_a((PlayerEntity)player);
                            if (target.func_70097_a(damageSource, (float)((int)damage))) {
                                Vector3d lookVec = player.func_70040_Z();
                                target.func_70024_g(lookVec.field_72450_a * knockback, Math.abs(lookVec.field_72448_b + (double)0.2f) * knockback, lookVec.field_72449_c * knockback);
                            }
                        }
                    });
                }
            });
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        super.onBlockStartBreak(itemstack, pos, player);
        return itemstack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            if (iItemHandler instanceof IModeChangingItem) {
                return ((IModeChangingItem)iItemHandler).getActiveModule().getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> {
                    if (pm instanceof IMiningEnhancementModule) {
                        return ((IMiningEnhancementModule)pm).onBlockStartBreak(itemstack, pos, player);
                    }
                    return false;
                }).orElse(false);
            }
            return false;
        }).orElse(false);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77969_a(newStack);
    }

    public int getHarvestLevel(ItemStack itemStack, ToolType toolType, @Nullable PlayerEntity player, @Nullable BlockState state) {
        return itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            if (iItemHandler instanceof IModeChangingItem) {
                int highestVal = 0;
                for (ItemStack module : ((IModeChangingItem)iItemHandler).getInstalledModulesOfType(IBlockBreakingModule.class)) {
                    int val = module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> {
                        if (pm instanceof IBlockBreakingModule) {
                            return ((IBlockBreakingModule)pm).getEmulatedTool().getHarvestLevel(toolType, player, state);
                        }
                        return -1;
                    }).orElse(-1);
                    if (val <= highestVal) continue;
                    highestVal = val;
                }
                return highestVal;
            }
            return -1;
        }).orElse(-1);
    }

    public boolean canHarvestBlock(ItemStack itemStack, BlockState state) {
        boolean retVal = itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(iItemHandler -> {
            if (iItemHandler instanceof IModeChangingItem) {
                for (ItemStack module : ((IModeChangingItem)iItemHandler).getInstalledModulesOfType(IBlockBreakingModule.class)) {
                    if (!module.getCapability(PowerModuleCapability.POWER_MODULE).map(pm -> {
                        if (pm instanceof IBlockBreakingModule && ((IBlockBreakingModule)pm).getEmulatedTool().func_150998_b(state)) {
                            return true;
                        }
                        return false;
                    }).orElse(false).booleanValue()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }).orElse(false);
        return retVal;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType fallback = ActionResultType.PASS;
        Hand hand = context.func_221531_n();
        if (hand != Hand.MAIN_HAND) {
            return fallback;
        }
        ItemStack fist = context.func_195996_i();
        return fist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> {
            if (handler instanceof IModeChangingItem) {
                ItemStack module = ((IModeChangingItem)handler).getActiveModule();
                return module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
                    if (m instanceof IRightClickModule) {
                        return ((IRightClickModule)m).onItemUse(context);
                    }
                    return fallback;
                }).orElse(fallback);
            }
            return fallback;
        }).orElse(fallback);
    }

    public ActionResultType onItemUseFirst(ItemStack itemStack, ItemUseContext context) {
        ActionResultType fallback = ActionResultType.PASS;
        Hand hand = context.func_221531_n();
        if (hand != Hand.MAIN_HAND) {
            return fallback;
        }
        ItemStack fist = context.func_195996_i();
        return fist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> {
            if (handler instanceof IModeChangingItem) {
                ItemStack module = ((IModeChangingItem)handler).getActiveModule();
                return module.getCapability(PowerModuleCapability.POWER_MODULE).map(m -> {
                    if (m instanceof IRightClickModule) {
                        return ((IRightClickModule)m).onItemUseFirst(itemStack, context);
                    }
                    return fallback;
                }).orElse(fallback);
            }
            return fallback;
        }).orElse(fallback);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            if (handler instanceof IModeChangingItem) {
                ItemStack module = ((IModeChangingItem)handler).getActiveModule();
                module.getCapability(PowerModuleCapability.POWER_MODULE).ifPresent(m -> {
                    if (m instanceof IRightClickModule) {
                        ((IRightClickModule)m).onPlayerStoppedUsing(stack, worldIn, entityLiving, timeLeft);
                    }
                });
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerIn, Hand handIn) {
        ItemStack fist = playerIn.func_184586_b(handIn);
        ActionResult fallback = new ActionResult(ActionResultType.PASS, (Object)fist);
        if (handIn != Hand.MAIN_HAND) {
            return fallback;
        }
        return fist.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> {
            if (handler instanceof IModeChangingItem) {
                return ((IModeChangingItem)handler).getActiveModule().getCapability(PowerModuleCapability.POWER_MODULE).map(rc -> rc instanceof IRightClickModule ? ((IRightClickModule)rc).onItemRightClick(fist, world, playerIn, handIn) : fallback).orElse(fallback);
            }
            return fallback;
        }).orElse(fallback);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }
}

