/*
 * Decompiled with CFR 0.152.
 */
package com.github.lehjr.powersuits.network.packets;

import com.github.lehjr.numina.util.capabilities.render.ModelSpecNBTCapability;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class ColourInfoPacket {
    protected int itemSlot;
    protected int[] tagData;

    public ColourInfoPacket() {
    }

    public ColourInfoPacket(int itemSlot, int[] tagData) {
        this.itemSlot = itemSlot;
        this.tagData = tagData;
    }

    public static void encode(ColourInfoPacket msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.itemSlot);
        packetBuffer.func_186875_a(msg.tagData);
    }

    public static ColourInfoPacket decode(PacketBuffer packetBuffer) {
        return new ColourInfoPacket(packetBuffer.readInt(), packetBuffer.func_186863_b());
    }

    public static void handle(ColourInfoPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            int itemSlot = message.itemSlot;
            int[] tagData = message.tagData;
            player.field_71071_by.func_70301_a(itemSlot).getCapability(ModelSpecNBTCapability.RENDER).ifPresent(render -> render.setColorArray(tagData));
        });
        ctx.get().setPacketHandled(true);
    }
}

