/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.recipe.ShapedRecipeHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.machinemuse.numina.recipe.ItemNameMappings;
import net.machinemuse.numina.recipe.JSONRecipe;
import net.machinemuse.numina.recipe.SimpleItemMatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class JSONRecipeHandler
extends ShapedRecipeHandler {
    private static Map<String, ArrayList<ItemStack>> itemMap;

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"nei.jsonShaped");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == JSONRecipeHandler.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                ShapedRecipeHandler.CachedShapedRecipe recipe = null;
                if (irecipe instanceof JSONRecipe) {
                    recipe = this.JSONShapedRecipe((JSONRecipe)irecipe);
                }
                if (recipe == null) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.func_77571_b(), (ItemStack)result)) continue;
            ShapedRecipeHandler.CachedShapedRecipe recipe = null;
            if (irecipe instanceof JSONRecipe) {
                recipe = this.JSONShapedRecipe((JSONRecipe)irecipe);
            }
            if (recipe == null) continue;
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            ShapedRecipeHandler.CachedShapedRecipe recipe = null;
            if (irecipe instanceof JSONRecipe) {
                recipe = this.JSONShapedRecipe((JSONRecipe)irecipe);
            }
            if (recipe == null || !recipe.contains((Collection)recipe.ingredients, ingredient)) continue;
            recipe.computeVisuals();
            if (!recipe.contains((Collection)recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation((Collection)recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public static ArrayList<ItemStack> getItemByUnlocalizedName(String unlocalizedName) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (itemMap == null) {
            if (ItemList.items.isEmpty()) {
                ItemStack stack = ItemNameMappings.getItem(unlocalizedName);
                if (stack != null) {
                    result.add(stack);
                }
            } else {
                itemMap = new HashMap<String, ArrayList<ItemStack>>();
                for (ItemStack stack : ItemList.items) {
                    String key = stack.func_77973_b().func_77667_c(stack);
                    if (!itemMap.containsKey(key)) {
                        itemMap.put(key, new ArrayList());
                    }
                    itemMap.get(key).add(stack);
                }
            }
        }
        if (itemMap != null && itemMap.containsKey(unlocalizedName)) {
            result.addAll((Collection<ItemStack>)itemMap.get(unlocalizedName));
        }
        return result;
    }

    public static List<ItemStack> getIngredient(SimpleItemMatcher cell) {
        String[] names;
        ArrayList<ItemStack> t;
        ArrayList<Object> result = null;
        if (cell == null) {
            return null;
        }
        if (cell.oredictName != null) {
            result = OreDictionary.getOres((String)cell.oredictName);
            if (cell.meta != null && result != null && cell.meta != Short.MAX_VALUE) {
                t = new ArrayList();
                for (ItemStack itemStack : result) {
                    if (cell.meta.intValue() != itemStack.func_77960_j()) continue;
                    t.add(itemStack);
                }
                result = t;
            }
        }
        if (cell.itemStackName != null) {
            names = cell.itemStackName.split(":");
            result = new ArrayList<ItemStack>();
            ItemStack stack = GameRegistry.findItemStack((String)names[0], (String)names[1], (int)1);
            if (stack != null) {
                stack = stack.func_77946_l();
                if (cell.meta != null) {
                    stack.func_77964_b(cell.meta.intValue());
                }
                result.add(stack);
            }
        }
        if (cell.registryName != null) {
            names = cell.registryName.split(":");
            result = new ArrayList();
            Item item = GameRegistry.findItem((String)names[0], (String)names[1]);
            if (item != null) {
                int n = cell.meta == null ? 0 : cell.meta;
                ItemStack stack = new ItemStack(item, 1, n);
                result.add(stack);
            }
        }
        if (cell.unlocalizedName != null) {
            if (result == null) {
                result = JSONRecipeHandler.getItemByUnlocalizedName(cell.unlocalizedName);
            } else {
                t = new ArrayList<ItemStack>();
                for (ItemStack itemStack : result) {
                    if (!cell.unlocalizedName.equals(itemStack.func_77973_b().func_77667_c(itemStack))) continue;
                    t.add(itemStack);
                }
                result = t;
            }
        }
        if (cell.nbtString != null && result != null) {
            t = new ArrayList();
            for (ItemStack itemStack : result) {
                ItemStack stack2 = itemStack.func_77946_l();
                try {
                    stack2.func_77982_d((NBTTagCompound)JsonToNBT.func_150315_a((String)cell.nbtString));
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
                t.add(stack2);
            }
            result = t;
        }
        return result;
    }

    public ShapedRecipeHandler.CachedShapedRecipe JSONShapedRecipe(JSONRecipe recipe) {
        int height = recipe.ingredients.length;
        int width = recipe.getWidth();
        if (height == 0 || width == 0) {
            return null;
        }
        Object[] items = new Object[height * width];
        for (int y = 0; y < height; ++y) {
            if (recipe.ingredients[y] == null) continue;
            for (int x = 0; x < width; ++x) {
                List<ItemStack> item = recipe.ingredients[y].length > x ? JSONRecipeHandler.getIngredient(recipe.ingredients[y][x]) : null;
                if (item != null && item.isEmpty()) {
                    return null;
                }
                items[y * width + x] = item;
            }
        }
        return new ShapedRecipeHandler.CachedShapedRecipe((ShapedRecipeHandler)this, width, height, items, recipe.func_77571_b());
    }
}

