/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.render;

import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.render.RenderState;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public final class MuseIconUtils {
    public static void drawIconAt(double x, double y, IIcon icon, Colour colour) {
        MuseIconUtils.drawIconPartial(x, y, icon, colour, 0.0, 0.0, 16.0, 16.0);
    }

    public static void drawIconPartialOccluded(double x, double y, IIcon icon, Colour colour, double left, double top, double right, double bottom) {
        double xmin = MuseMathUtils.clampDouble(left - x, 0.0, 16.0);
        double ymin = MuseMathUtils.clampDouble(top - y, 0.0, 16.0);
        double xmax = MuseMathUtils.clampDouble(right - x, 0.0, 16.0);
        double ymax = MuseMathUtils.clampDouble(bottom - y, 0.0, 16.0);
        MuseIconUtils.drawIconPartial(x, y, icon, colour, xmin, ymin, xmax, ymax);
    }

    public static void drawIconPartial(double x, double y, IIcon icon, Colour colour, double left, double top, double right, double bottom) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        RenderState.on2D();
        RenderState.blendingOn();
        if (colour != null) {
            colour.doGL();
        }
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        float u1 = icon.func_94209_e();
        float v1 = icon.func_94206_g();
        float u2 = icon.func_94212_f();
        float v2 = icon.func_94210_h();
        double xoffset1 = left * (double)(u2 - u1) / 16.0;
        double yoffset1 = top * (double)(v2 - v1) / 16.0;
        double xoffset2 = right * (double)(u2 - u1) / 16.0;
        double yoffset2 = bottom * (double)(v2 - v1) / 16.0;
        tess.func_78374_a(x + left, y + top, 0.0, (double)u1 + xoffset1, (double)v1 + yoffset1);
        tess.func_78374_a(x + left, y + bottom, 0.0, (double)u1 + xoffset1, (double)v1 + yoffset2);
        tess.func_78374_a(x + right, y + bottom, 0.0, (double)u1 + xoffset2, (double)v1 + yoffset2);
        tess.func_78374_a(x + right, y + top, 0.0, (double)u1 + xoffset2, (double)v1 + yoffset1);
        tess.func_78381_a();
        RenderState.blendingOff();
        RenderState.off2D();
        GL11.glPopMatrix();
    }
}

