/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.api.electricity;

import appeng.api.config.AccessRestriction;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricConversions;
import net.machinemuse.api.electricity.IMuseElectricItem;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MuseElectricItem
extends Item
implements IMuseElectricItem {
    private static MuseElectricItem INSTANCE;

    public static MuseElectricItem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MuseElectricItem();
        }
        return INSTANCE;
    }

    @Override
    public double getCurrentEnergy(ItemStack stack) {
        return MuseItemUtils.getDoubleOrZero(stack, "Current Energy");
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return ModuleManager.computeModularProperty(stack, "Maximum Energy");
    }

    @Override
    public void setCurrentEnergy(ItemStack stack, double energy) {
        MuseItemUtils.setDoubleOrRemove(stack, "Current Energy", Math.min(energy, this.getMaxEnergy(stack)));
    }

    @Override
    public double drainEnergyFrom(ItemStack stack, double requested) {
        double available = this.getCurrentEnergy(stack);
        if (available > requested) {
            this.setCurrentEnergy(stack, available - requested);
            return requested;
        }
        this.setCurrentEnergy(stack, 0.0);
        return available;
    }

    @Override
    public double giveEnergyTo(ItemStack stack, double provided) {
        double max;
        double available = this.getCurrentEnergy(stack);
        if (available + provided < (max = this.getMaxEnergy(stack))) {
            this.setCurrentEnergy(stack, available + provided);
            return provided;
        }
        this.setCurrentEnergy(stack, max);
        return max - available;
    }

    @Override
    public int getMaxDamage(ItemStack itemStack) {
        return 0;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public double getMaxCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getMaxEnergy(itemStack));
    }

    @Override
    public int getTier(ItemStack itemStack) {
        return ElectricConversions.getTier(itemStack);
    }

    @Override
    public double getTransferLimit(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(Math.sqrt(this.getMaxEnergy(itemStack)));
    }

    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : this.getTransferLimit(itemStack);
        double given = this.giveEnergyTo(itemStack, transfer);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToEU(given);
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double transfer = ignoreTransferLimit || amount < this.getTransferLimit(itemStack) ? ElectricConversions.museEnergyFromEU(amount) : this.getTransferLimit(itemStack);
        double taken = this.drainEnergyFrom(itemStack, transfer);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToEU(taken);
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        return ElectricConversions.museEnergyToEU(this.getCurrentEnergy(itemStack));
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        return ElectricConversions.museEnergyFromEU(amount) < this.getCurrentEnergy(itemStack);
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        return ElectricItem.rawManager.use(itemStack, ElectricConversions.museEnergyToEU(amount), entity);
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        ElectricItem.rawManager.chargeFromArmor(itemStack, entity);
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        return "";
    }

    @Override
    public IElectricItemManager getManager(ItemStack itemStack) {
        return this;
    }

    @Override
    public int receiveEnergy(ItemStack itemStack, int energy, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double receivedME = ElectricConversions.museEnergyFromRF(energy);
        double eatenME = this.giveEnergyTo(itemStack, receivedME);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToRF(eatenME);
    }

    @Override
    public int extractEnergy(ItemStack itemStack, int energy, boolean simulate) {
        double current = this.getCurrentEnergy(itemStack);
        double requesteddME = ElectricConversions.museEnergyFromRF(energy);
        double takenME = this.drainEnergyFrom(itemStack, requesteddME);
        if (simulate) {
            this.setCurrentEnergy(itemStack, current);
        }
        return ElectricConversions.museEnergyToRF(takenME);
    }

    @Override
    public int getEnergyStored(ItemStack itemStack) {
        return ElectricConversions.museEnergyToRF(this.getCurrentEnergy(itemStack));
    }

    @Override
    public int getMaxEnergyStored(ItemStack itemStack) {
        return ElectricConversions.museEnergyToRF(this.getMaxEnergy(itemStack));
    }

    @Override
    public double injectAEPower(ItemStack itemStack, double ae) {
        double current = this.getCurrentEnergy(itemStack);
        double recieved = ElectricConversions.museEnergyFromAE(ae);
        this.setCurrentEnergy(itemStack, current);
        return ElectricConversions.museEnergyToAE(recieved);
    }

    @Override
    public double extractAEPower(ItemStack itemStack, double ae) {
        double current = this.getCurrentEnergy(itemStack);
        double taken = ElectricConversions.museEnergyFromAE(ae);
        this.setCurrentEnergy(itemStack, current);
        return ElectricConversions.museEnergyToAE(taken);
    }

    @Override
    public double getAEMaxPower(ItemStack itemStack) {
        return ElectricConversions.museEnergyToAE(this.getCurrentEnergy(itemStack));
    }

    @Override
    public double getAECurrentPower(ItemStack itemStack) {
        return ElectricConversions.museEnergyToAE(this.getCurrentEnergy(itemStack));
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return AccessRestriction.READ_WRITE;
    }
}

