/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.powermodule.PowerModule;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.MuseStringUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class DetailedSummaryFrame
extends ScrollableFrame {
    public static final double SCALEFACTOR = 1.0;
    protected EntityPlayer player;
    protected double weight;
    protected double energy;
    protected double armor;

    public DetailedSummaryFrame(EntityPlayer player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        super(topleft.times(1.0), bottomright.times(1.0), borderColour, insideColour);
        this.player = player;
    }

    @Override
    public void update(double mousex, double mousey) {
        this.weight = MuseItemUtils.getPlayerWeight(this.player);
        this.energy = 0.0;
        this.armor = 0.0;
        for (ItemStack stack : MuseItemUtils.modularItemsEquipped(this.player)) {
            this.energy += ModuleManager.computeModularProperty(stack, "Maximum Energy");
            this.armor += ModuleManager.computeModularProperty(stack, "Armor (Physical)");
            this.armor += ModuleManager.computeModularProperty(stack, "Armor (Energy)");
        }
    }

    @Override
    public void draw() {
        if (this.player != null) {
            int i;
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            super.draw();
            int margin = 4;
            int nexty = (int)this.border.top() + margin;
            MuseRenderer.drawCenteredString(StatCollector.func_74838_a((String)"gui.equippedTotals"), (this.border.left() + this.border.right()) / 2.0, nexty);
            nexty += 10;
            String formattedValue = MuseStringUtils.formatNumberFromUnits(this.energy, PowerModule.getUnit("Maximum Energy"));
            String name = StatCollector.func_74838_a((String)"gui.energyStorage");
            double valueWidth = MuseRenderer.getStringWidth(formattedValue);
            double allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
            List<String> namesList = MuseStringUtils.wrapStringToVisualLength(name, allowedNameWidth);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawString(namesList.get(i), this.border.left() + (double)margin, nexty + 9 * i);
            }
            MuseRenderer.drawRightAlignedString(formattedValue, this.border.right() - (double)margin, nexty + 9 * (namesList.size() - 1) / 2);
            nexty += 10 * namesList.size() + 1;
            formattedValue = MuseStringUtils.wrapFormatTags(MuseStringUtils.formatNumberFromUnits(this.weight, PowerModule.getUnit("Weight")), this.weight > Config.getWeightCapacity() ? MuseStringUtils.FormatCodes.Red : MuseStringUtils.FormatCodes.BrightGreen);
            name = StatCollector.func_74838_a((String)"gui.weight");
            valueWidth = MuseRenderer.getStringWidth(formattedValue);
            allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
            namesList = MuseStringUtils.wrapStringToVisualLength(name, allowedNameWidth);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawString(namesList.get(i), this.border.left() + (double)margin, nexty + 9 * i);
            }
            MuseRenderer.drawRightAlignedString(formattedValue, this.border.right() - (double)margin, nexty + 9 * (namesList.size() - 1) / 2);
            nexty += 10 * namesList.size() + 1;
            formattedValue = MuseStringUtils.formatNumberFromUnits(this.armor, "pts");
            name = StatCollector.func_74838_a((String)"gui.armor");
            valueWidth = MuseRenderer.getStringWidth(formattedValue);
            allowedNameWidth = this.border.width() - valueWidth - (double)(margin * 2);
            namesList = MuseStringUtils.wrapStringToVisualLength(name, allowedNameWidth);
            for (i = 0; i < namesList.size(); ++i) {
                MuseRenderer.drawString(namesList.get(i), this.border.left() + (double)margin, nexty + 9 * i);
            }
            MuseRenderer.drawRightAlignedString(formattedValue, this.border.right() - (double)margin, nexty + 9 * (namesList.size() - 1) / 2);
            GL11.glPopMatrix();
        }
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

