/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.Arrays;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.general.gui.clickable.ClickableItem;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.utils.MuseItemUtils;
import net.machinemuse.utils.render.MuseRenderer;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class ItemInfoFrame
extends ScrollableFrame {
    public static final double SCALEFACTOR = 1.0;
    protected ItemSelectionFrame target;
    protected EntityPlayer player;
    protected List<String> info;

    public ItemInfoFrame(EntityPlayer player, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour, ItemSelectionFrame target) {
        super(topleft.times(1.0), bottomright.times(1.0), borderColour, insideColour);
        this.target = target;
        this.player = player;
    }

    @Override
    public void update(double mousex, double mousey) {
        ClickableItem selected = this.target.getSelectedItem();
        if (selected != null) {
            IModularItem item = MuseItemUtils.getAsModular(selected.getItem().func_77973_b());
            this.info = item.getLongInfo(this.player, selected.getItem());
        } else {
            this.info = null;
        }
    }

    @Override
    public void draw() {
        if (this.info != null) {
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            super.draw();
            int xoffset = 8;
            int yoffset = 8;
            int i = 0;
            for (String infostring : this.info) {
                String[] str = infostring.split("\t");
                MuseRenderer.drawStringsJustified(Arrays.asList(str), this.border.left() + (double)xoffset, this.border.right() - (double)xoffset, this.border.top() + (double)yoffset + (double)(i * 10));
                ++i;
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
    }

    @Override
    public void onMouseUp(double x, double y, int button) {
    }

    @Override
    public List<String> getToolTip(int x, int y) {
        return null;
    }
}

