/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general.gui.frame;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.machinemuse.general.gui.frame.ColourPickerFrame;
import net.machinemuse.general.gui.frame.ItemSelectionFrame;
import net.machinemuse.general.gui.frame.PartManipSubFrame;
import net.machinemuse.general.gui.frame.ScrollableFrame;
import net.machinemuse.numina.geometry.Colour;
import net.machinemuse.numina.geometry.MusePoint2D;
import net.machinemuse.numina.geometry.MuseRect;
import net.machinemuse.numina.geometry.MuseRelativeRect;
import net.machinemuse.powersuits.client.render.modelspec.ModelRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class PartManipContainer
extends ScrollableFrame {
    public ItemSelectionFrame itemSelect;
    public ColourPickerFrame colourSelect;
    public MusePoint2D topleft;
    public MusePoint2D bottomright;
    public Integer lastItemSlot;
    public int lastColour;
    public int lastColourIndex;
    public List<PartManipSubFrame> modelframes = new ArrayList<PartManipSubFrame>();

    public PartManipContainer(ItemSelectionFrame itemSelect, ColourPickerFrame colourSelect, MusePoint2D topleft, MusePoint2D bottomright, Colour borderColour, Colour insideColour) {
        super(topleft, bottomright, borderColour, insideColour);
        this.itemSelect = itemSelect;
        this.colourSelect = colourSelect;
        this.topleft = topleft;
        this.bottomright = bottomright;
        this.lastItemSlot = null;
        this.lastColour = this.getColour();
        this.lastColourIndex = this.getColourIndex();
        this.modelframes = this.getModelframes();
    }

    @Nullable
    public ItemStack getItem() {
        return this.itemSelect.getSelectedItem() != null ? this.itemSelect.getSelectedItem().getItem() : null;
    }

    @Nullable
    public Integer getItemSlot() {
        return this.itemSelect.getSelectedItem() != null ? Integer.valueOf(this.itemSelect.getSelectedItem().inventorySlot) : null;
    }

    public int getColour() {
        if (this.getItem() == null) {
            return Colour.WHITE.getInt();
        }
        if (this.colourSelect.selectedColour < this.colourSelect.colours().length && this.colourSelect.selectedColour >= 0) {
            return this.colourSelect.colours()[this.colourSelect.selectedColour];
        }
        return Colour.WHITE.getInt();
    }

    public int getColourIndex() {
        return this.colourSelect.selectedColour;
    }

    public List<PartManipSubFrame> getModelframes() {
        ArrayList<PartManipSubFrame> modelframesList = new ArrayList<PartManipSubFrame>();
        Collection specCollection = ModelRegistry.getInstance().apply().values();
        PartManipSubFrame prev = null;
        PartManipSubFrame newframe = null;
        for (ModelSpec modelspec : specCollection) {
            prev = newframe = this.createNewFrame(modelspec, prev);
            modelframesList.add(newframe);
        }
        return modelframesList;
    }

    public PartManipSubFrame createNewFrame(ModelSpec modelspec, PartManipSubFrame prev) {
        MuseRelativeRect newborder = new MuseRelativeRect(this.topleft.x() + 4.0, this.topleft.y() + 4.0, this.bottomright.x(), this.topleft.y() + 10.0);
        newborder.setBelow((MuseRect)(prev != null ? prev.border : null));
        return new PartManipSubFrame(modelspec, this.colourSelect, this.itemSelect, newborder);
    }

    @Override
    public void onMouseDown(double x, double y, int button) {
        if (button == 0) {
            for (PartManipSubFrame frame : this.modelframes) {
                frame.tryMouseClick(x, y + (double)this.currentscrollpixels);
            }
        }
    }

    @Override
    public void update(double mousex, double mousey) {
        super.update(mousex, mousey);
        if (!Objects.equals(this.lastItemSlot, this.getItemSlot())) {
            this.lastItemSlot = this.getItemSlot();
            this.colourSelect.refreshColours();
            double x = 0.0;
            for (PartManipSubFrame subframe : this.modelframes) {
                subframe.updateItems();
                x += subframe.border.bottom();
            }
            this.totalsize = (int)x;
        }
        if (this.colourSelect.decrAbove > -1) {
            this.decrAbove(this.colourSelect.decrAbove);
            this.colourSelect.decrAbove = -1;
        }
    }

    public void decrAbove(int index) {
        for (PartManipSubFrame frame : this.modelframes) {
            frame.decrAbove(index);
        }
    }

    @Override
    public void draw() {
        super.preDraw();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)(-this.currentscrollpixels), (double)0.0);
        for (PartManipSubFrame f : this.modelframes) {
            f.drawPartial((double)(this.currentscrollpixels + 4) + this.border.top(), (double)this.currentscrollpixels + this.border.bottom() - 4.0);
        }
        GL11.glPopMatrix();
        super.postDraw();
    }
}

