/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.modelspec;

import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.scala.MuseRegistry;
import net.machinemuse.powersuits.client.render.modelspec.ModelPartSpec;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpec;
import net.machinemuse.utils.MuseStringUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.WavefrontObject;

public class ModelRegistry
extends MuseRegistry<ModelSpec> {
    private static ModelRegistry INSTANCE;

    private ModelRegistry() {
    }

    public static ModelRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModelRegistry();
        }
        return INSTANCE;
    }

    public WavefrontObject loadModel(ResourceLocation resource) {
        String name = MuseStringUtils.extractName(resource);
        ModelSpec spec = (ModelSpec)((Object)this.get(name));
        if (spec == null) {
            return this.wrap(resource);
        }
        return spec.model;
    }

    public WavefrontObject wrap(ResourceLocation resource) {
        MuseLogger.logDebug((String)("Loading " + resource + " as " + MuseStringUtils.extractName(resource)));
        IModelCustom model = AdvancedModelLoader.loadModel((ResourceLocation)resource);
        if (model instanceof WavefrontObject) {
            return (WavefrontObject)model;
        }
        MuseLogger.logError((String)("Model loading failed :( " + resource));
        return null;
    }

    public ModelSpec getModel(NBTTagCompound nbt) {
        return (ModelSpec)((Object)this.get(nbt.func_74779_i("model")));
    }

    public ModelPartSpec getPart(NBTTagCompound nbt, ModelSpec model) {
        return (ModelPartSpec)model.get(nbt.func_74779_i("part"));
    }

    public ModelPartSpec getPart(NBTTagCompound nbt) {
        return this.getPart(nbt, this.getModel(nbt));
    }

    public NBTTagCompound getSpecTag(NBTTagCompound museRenderTag, ModelPartSpec spec) {
        String name = this.makeName(spec);
        return museRenderTag.func_74764_b(name) ? museRenderTag.func_74775_l(name) : null;
    }

    public String makeName(ModelPartSpec spec) {
        return spec.modelSpec.getOwnName() + "." + spec.partName;
    }
}

