/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.proxy;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import java.net.URL;
import net.machinemuse.general.sound.SoundDictionary;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.MusePacketModeChangeRequest;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.numina.render.RenderGameOverlayEventHandler;
import net.machinemuse.powersuits.block.BlockTinkerTable;
import net.machinemuse.powersuits.block.TileEntityLuxCapacitor;
import net.machinemuse.powersuits.block.TileEntityTinkerTable;
import net.machinemuse.powersuits.client.render.block.RenderLuxCapacitorTESR;
import net.machinemuse.powersuits.client.render.block.TinkerTableRenderer;
import net.machinemuse.powersuits.client.render.entity.RenderLuxCapacitorEntity;
import net.machinemuse.powersuits.client.render.entity.RenderPlasmaBolt;
import net.machinemuse.powersuits.client.render.entity.RenderSpinningBlade;
import net.machinemuse.powersuits.client.render.item.ToolRenderer;
import net.machinemuse.powersuits.client.render.modelspec.ModelSpecXMLReader;
import net.machinemuse.powersuits.common.MPSItems;
import net.machinemuse.powersuits.common.proxy.CommonProxy;
import net.machinemuse.powersuits.control.KeybindKeyHandler;
import net.machinemuse.powersuits.control.KeybindManager;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.entity.EntitySpinningBlade;
import net.machinemuse.powersuits.event.ClientTickHandler;
import net.machinemuse.powersuits.event.PlayerUpdateHandler;
import net.machinemuse.powersuits.event.RenderEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerEvents() {
        super.registerEvents();
        MinecraftForge.EVENT_BUS.register((Object)new SoundDictionary());
    }

    @Override
    public void registerRenderers() {
        super.registerRenderers();
        MinecraftForgeClient.registerItemRenderer((Item)MPSItems.getInstance().powerTool, (IItemRenderer)new ToolRenderer());
        int tinkTableRenderID = RenderingRegistry.getNextAvailableRenderId();
        TinkerTableRenderer tinkTableRenderer = new TinkerTableRenderer(tinkTableRenderID);
        BlockTinkerTable.setRenderType(tinkTableRenderID);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTinkerTable.class, (TileEntitySpecialRenderer)tinkTableRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)tinkTableRenderer);
        int luxCapacitorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderLuxCapacitorTESR luxCapacitorRenderer = new RenderLuxCapacitorTESR(luxCapacitorRenderID);
        MPSItems.getInstance().luxCapacitor.setRenderType(luxCapacitorRenderID);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLuxCapacitor.class, (TileEntitySpecialRenderer)luxCapacitorRenderer);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)luxCapacitorRenderer);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlasmaBolt.class, (Render)new RenderPlasmaBolt());
        RenderingRegistry.registerEntityRenderingHandler(EntitySpinningBlade.class, (Render)new RenderSpinningBlade());
        RenderingRegistry.registerEntityRenderingHandler(EntityLuxCapacitor.class, (Render)new RenderLuxCapacitorEntity());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
        URL resource = ClientProxy.class.getResource("/assets/powersuits/models/modelspec.xml");
        ModelSpecXMLReader.getINSTANCE().parseFile(resource);
        URL otherResource = ClientProxy.class.getResource("/assets/powersuits/models/armor2.xml");
        ModelSpecXMLReader.getINSTANCE().parseFile(otherResource);
    }

    @Override
    public void registerHandlers() {
        super.registerHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerUpdateHandler());
        FMLCommonHandler.instance().bus().register((Object)new KeybindKeyHandler());
        FMLCommonHandler.instance().bus().register((Object)new ClientTickHandler());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        KeybindManager.readInKeybinds();
    }

    @Override
    public void sendModeChange(int dMode, String newMode) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        RenderGameOverlayEventHandler.updateSwap((int)((int)Math.signum(dMode)));
        MusePacketModeChangeRequest modeChangePacket = new MusePacketModeChangeRequest((EntityPlayer)player, newMode, player.field_71071_by.field_70461_c);
        PacketSender.sendToServer((MusePacket)modeChangePacket);
    }
}

