/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.machinemuse.api.IApiaristArmor;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.powersuits.client.render.item.ArmorModelInstance;
import net.machinemuse.powersuits.client.render.item.IArmorModel;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemElectricArmor;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public abstract class ItemPowerArmor
extends ItemElectricArmor
implements ISpecialArmor,
IApiaristArmor {
    public ItemPowerArmor(int renderIndex, int armorType) {
        super(ItemArmor.ArmorMaterial.IRON, renderIndex, armorType);
        this.func_77625_d(1);
        this.func_77637_a(Config.getCreativeTab());
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "powersuits:textures/models/blankarmor.png";
    }

    public int func_82814_b(ItemStack stack) {
        return this.getColorFromItemStack(stack).getInt();
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelBiped model = ArmorModelInstance.getInstance();
        ((IArmorModel)model).setVisibleSection(armorSlot);
        if (itemStack != null && entityLiving instanceof EntityPlayer) {
            ItemStack chest = ((EntityPlayer)entityLiving).func_82169_q(2);
            if (itemStack != null && ModuleManager.itemHasActiveModule(chest, "Active Camouflage")) {
                ((IArmorModel)model).setVisibleSection(99);
            }
        }
        if (ModuleManager.itemHasActiveModule(itemStack, "Transparent Armor")) {
            ((IArmorModel)model).setVisibleSection(99);
        }
        ((IArmorModel)model).setRenderSpec(MuseItemUtils.getMuseRenderTag(itemStack, armorSlot));
        return model;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap parent = super.getAttributeModifiers(stack);
        parent.put((Object)"generic.knockbackResistance", (Object)new AttributeModifier(UUID.fromString("448ef0e9-9b7c-4e56-bf3a-6b52aeabff8d"), "generic.knockbackResistance", 0.25, 0));
        return parent;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82816_b_(ItemStack stack) {
        NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
        return ModuleManager.tagHasModule(itemTag, "Red Tint") || ModuleManager.tagHasModule(itemTag, "Green Tint") || ModuleManager.tagHasModule(itemTag, "Blue Tint");
    }

    double getHeatResistance(EntityPlayer player, ItemStack stack) {
        return MuseHeatUtils.getMaxHeat(stack);
    }

    @Override
    public double getArmorDouble(EntityPlayer player, ItemStack stack) {
        double totalArmor = 0.0;
        NBTTagCompound props = MuseItemUtils.getMuseItemTag(stack);
        double energy = ElectricItemUtils.getPlayerEnergy(player);
        double physArmor = ModuleManager.computeModularProperty(stack, "Armor (Physical)");
        double enerArmor = ModuleManager.computeModularProperty(stack, "Armor (Energy)");
        double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
        totalArmor += physArmor;
        if (energy > enerConsum) {
            totalArmor += enerArmor;
        }
        totalArmor = Math.min(Config.getMaximumArmorPerPiece(), totalArmor);
        return totalArmor;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int priority = 0;
        if (source.func_76347_k() && source != MuseHeatUtils.overheatDamage) {
            return new ISpecialArmor.ArmorProperties(priority, 0.25, (int)(25.0 * damage));
        }
        if (ModuleManager.itemHasModule(armor, "Radiation Shielding") && (source.field_76373_n.equals("electricity") || source.field_76373_n.equals("radiation"))) {
            return new ISpecialArmor.ArmorProperties(priority, 0.25, (int)(25.0 * damage));
        }
        double armorDouble = player instanceof EntityPlayer ? this.getArmorDouble((EntityPlayer)player, armor) : 2.0;
        double absorbRatio = 0.04 * armorDouble;
        int absorbMax = (int)armorDouble * 75;
        if (source.func_76363_c()) {
            absorbMax = 0;
            absorbRatio = 0.0;
        }
        return new ISpecialArmor.ArmorProperties(priority, absorbRatio, absorbMax);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)this.getArmorDouble(player, armor);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        NBTTagCompound itemProperties = MuseItemUtils.getMuseItemTag(stack);
        if (entity instanceof EntityPlayer && source != MuseHeatUtils.overheatDamage) {
            if (source.func_76347_k()) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!source.equals(DamageSource.field_76370_b) || MuseHeatUtils.getPlayerHeat(player) < MuseHeatUtils.getMaxHeat(player)) {
                    MuseHeatUtils.heatPlayer(player, damage);
                }
            } else {
                double enerConsum = ModuleManager.computeModularProperty(stack, "Energy Per Damage");
                double drain = enerConsum * (double)damage;
                if (entity instanceof EntityPlayer) {
                    ElectricItemUtils.drainPlayerEnergy((EntityPlayer)entity, drain);
                } else {
                    this.drainEnergyFrom(stack, drain);
                }
            }
        }
    }

    @Override
    @Optional.Method(modid="Forestry")
    public boolean protectPlayer(EntityPlayer player, ItemStack armor, String cause, boolean doProtect) {
        return false;
    }

    @Override
    @Optional.Method(modid="Forestry")
    public boolean protectEntity(EntityLivingBase player, ItemStack armor, String cause, boolean doProtect) {
        if (ModuleManager.itemHasActiveModule(armor, "Apiarist Armor")) {
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)player, ModuleManager.computeModularProperty(armor, "Apiarist Armor Energy Consumption"));
            return true;
        }
        return false;
    }
}

