/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.item;

import appeng.api.implementations.items.IAEWrench;
import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import com.bluepowermod.api.misc.IScrewdriver;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.tool.ITool;
import forestry.api.arboriculture.IToolGrafter;
import java.util.List;
import mekanism.api.IMekWrench;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.numina.item.NuminaItemUtils;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.MusePacketModeChangeRequest;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.IModeChangingModularItem;
import net.machinemuse.powersuits.item.MPSItemElectricTool;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseHeatUtils;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.IMFRHammer;

@Optional.InterfaceList(value={@Optional.Interface(iface="mekanism.api.IMekWrench", modid="Mekanism", striprefs=true), @Optional.Interface(iface="crazypants.enderio.api.tool.ITool", modid="EnderIO", striprefs=true), @Optional.Interface(iface="mrtjp.projectred.api.IScrewdriver", modid="ProjRed|Core", striprefs=true), @Optional.Interface(iface="com.bluepowermod.api.misc.IScrewdriver", modid="bluepower", striprefs=true), @Optional.Interface(iface="forestry.api.arboriculture.IToolGrafter", modid="Forestry", striprefs=true), @Optional.Interface(iface="mods.railcraft.api.core.items.IToolCrowbar", modid="Railcraft", striprefs=true), @Optional.Interface(iface="powercrystals.minefactoryreloaded.api.IMFRHammer", modid="MineFactoryReloaded", striprefs=true), @Optional.Interface(iface="cofh.api.item.IToolHammer", modid="CoFHCore", striprefs=true), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft|Core", striprefs=true), @Optional.Interface(iface="appeng.api.implementations.items.IAEWrench", modid="appliedenergistics2", striprefs=true)})
public class ItemPowerFist
extends MPSItemElectricTool
implements IModularItem,
IToolGrafter,
IToolHammer,
IMFRHammer,
IToolCrowbar,
IAEWrench,
IToolWrench,
IScrewdriver,
mrtjp.projectred.api.IScrewdriver,
ITool,
IMekWrench,
IModeChangingModularItem {
    public final String iconpath = "powersuits:handitem";

    public ItemPowerFist() {
        super(0.0f, Item.ToolMaterial.EMERALD);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77637_a(Config.getCreativeTab());
        this.func_77655_b("powerFist");
    }

    public float func_150893_a(ItemStack stack, Block block) {
        return 1.0f;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        return this.func_150893_a(stack, block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("powersuits:handitem");
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityBeingHit, EntityLivingBase entityDoingHitting) {
        if (ModuleManager.itemHasActiveModule(stack, "Prototype OmniWrench")) {
            entityBeingHit.field_70177_z += 90.0f;
            entityBeingHit.field_70177_z %= 360.0f;
        }
        if (entityDoingHitting instanceof EntityPlayer && ModuleManager.itemHasActiveModule(stack, "Melee Assist")) {
            EntityPlayer player = (EntityPlayer)entityDoingHitting;
            double drain = ModuleManager.computeModularProperty(stack, "Punch Energy Consumption");
            if (ElectricItemUtils.getPlayerEnergy(player) > drain) {
                ElectricItemUtils.drainPlayerEnergy(player, drain);
                double damage = ModuleManager.computeModularProperty(stack, "Melee Damage");
                double knockback = ModuleManager.computeModularProperty(stack, "Melee Knockback");
                DamageSource damageSource = DamageSource.func_76365_a((EntityPlayer)player);
                if (entityBeingHit.func_70097_a(damageSource, (float)((int)damage))) {
                    Vec3 lookVec = player.func_70040_Z();
                    entityBeingHit.func_70024_g(lookVec.field_72450_a * knockback, Math.abs(lookVec.field_72448_b + (double)0.2f) * knockback, lookVec.field_72449_c * knockback);
                }
            }
        }
        return true;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            for (IBlockBreakingModule module : ModuleManager.getBlockBreakingModules()) {
                if (!ModuleManager.itemHasActiveModule(stack, module.getDataName()) || !module.onBlockDestroyed(stack, world, block, x, y, z, (EntityPlayer)entity)) continue;
                return true;
            }
        }
        return true;
    }

    public float getDamageVsEntity(Entity entity, ItemStack itemStack) {
        return (float)ModuleManager.computeModularProperty(itemStack, "Melee Damage");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack par1stack, ItemStack par2stack) {
        return false;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        for (IRightClickModule module : ModuleManager.getRightClickModules()) {
            if (!module.isValidForItem(itemStack) || !ModuleManager.itemHasActiveModule(itemStack, module.getDataName())) continue;
            module.onRightClick(player, world, itemStack);
        }
        return itemStack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.bow;
    }

    public void func_77615_a(ItemStack itemStack, World world, EntityPlayer player, int par4) {
        String mode = this.getActiveMode(itemStack, player);
        IPowerModule module = ModuleManager.getModule(mode);
        if (module != null) {
            ((IRightClickModule)module).onPlayerStoppedUsing(itemStack, world, player, par4);
        }
    }

    public boolean shouldPassSneakingClickToBlock(World world, int x, int y, int z) {
        return true;
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        String mode = this.getActiveMode(itemStack, player);
        IPowerModule module = ModuleManager.getModule(mode);
        return module instanceof IRightClickModule && ((IRightClickModule)module).onItemUseFirst(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        String mode = this.getActiveMode(itemStack, player);
        IPowerModule module = ModuleManager.getModule(mode);
        if (module instanceof IRightClickModule) {
            return ((IRightClickModule)module).onItemUse(itemStack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public boolean canHarvestBlock(ItemStack stack, Block block, int meta, EntityPlayer player) {
        if (block.func_149688_o().func_76229_l()) {
            return true;
        }
        for (IBlockBreakingModule module : ModuleManager.getBlockBreakingModules()) {
            if (!ModuleManager.itemHasActiveModule(stack, module.getDataName()) || !module.canHarvestBlock(stack, block, meta, player)) continue;
            return true;
        }
        return false;
    }

    @Optional.Method(modid="Forestry")
    public float getSaplingModifier(ItemStack itemStack, World world, EntityPlayer entityPlayer, int x, int y, int z) {
        if (ModuleManager.itemHasActiveModule(itemStack, "Grafter")) {
            ElectricItemUtils.drainPlayerEnergy(entityPlayer, ModuleManager.computeModularProperty(itemStack, "Grafter Energy Consumption"));
            MuseHeatUtils.heatPlayer(entityPlayer, ModuleManager.computeModularProperty(itemStack, "Grafter Heat Generation"));
            return 100.0f;
        }
        return 0.0f;
    }

    public boolean isUsable(ItemStack itemStack, EntityLivingBase entityLivingBase, int i, int i1, int i2) {
        return entityLivingBase instanceof EntityPlayer && this.getActiveMode(itemStack).equals("Prototype OmniWrench");
    }

    public void toolUsed(ItemStack itemStack, EntityLivingBase entityLivingBase, int i, int i1, int i2) {
    }

    public boolean canWhack(EntityPlayer entityPlayer, ItemStack itemStack, int i, int i1, int i2) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public boolean canLink(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public boolean canBoost(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public void onLink(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
    }

    public void onWhack(EntityPlayer entityPlayer, ItemStack itemStack, int i, int i1, int i2) {
    }

    public void onBoost(EntityPlayer entityPlayer, ItemStack itemStack, EntityMinecart entityMinecart) {
    }

    public boolean canWrench(ItemStack itemStack, EntityPlayer entityPlayer, int i, int i1, int i2) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public void wrenchUsed(EntityPlayer entityPlayer, int i, int i1, int i2) {
    }

    public boolean canWrench(EntityPlayer entityPlayer, int i, int i1, int i2) {
        return this.getActiveMode(entityPlayer.func_70694_bm(), entityPlayer).equals("Prototype OmniWrench");
    }

    public boolean damage(ItemStack itemStack, int i, EntityPlayer entityPlayer, boolean b) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public void damageScrewdriver(EntityPlayer entityPlayer, ItemStack itemStack) {
    }

    public boolean canUse(EntityPlayer entityPlayer, ItemStack itemStack) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public void used(ItemStack itemStack, EntityPlayer entityPlayer, int i, int i1, int i2) {
    }

    public boolean canUse(ItemStack itemStack, EntityPlayer entityPlayer, int i, int i1, int i2) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public boolean shouldHideFacades(ItemStack itemStack, EntityPlayer entityPlayer) {
        return this.getActiveMode(itemStack, entityPlayer).equals("Prototype OmniWrench");
    }

    public boolean canUseWrench(EntityPlayer entityPlayer, int i, int i1, int i2) {
        return this.getActiveMode(entityPlayer.func_70694_bm(), entityPlayer).equals("Prototype OmniWrench");
    }

    public void setActiveMode(ItemStack itemStack, String newMode) {
        NuminaItemUtils.getTagCompound((ItemStack)itemStack).func_74778_a("mode", newMode);
    }

    public String getActiveMode(ItemStack itemStack, EntityPlayer player) {
        return this.getActiveMode(itemStack);
    }

    public void cycleMode(ItemStack itemStack, EntityPlayer player, int dMode) {
        List<String> modes = this.getValidModes(itemStack, player);
        if (!modes.isEmpty()) {
            int newindex = this.clampMode(modes.indexOf(this.getActiveMode(itemStack, player)) + dMode, modes.size());
            String newmode = modes.get(newindex);
            this.setActiveMode(itemStack, newmode);
            PacketSender.sendToServer((MusePacket)new MusePacketModeChangeRequest(player, newmode, player.field_71071_by.field_70461_c));
        }
    }

    public String nextMode(ItemStack itemStack, EntityPlayer player) {
        List<String> modes = this.getValidModes(itemStack, player);
        if (!modes.isEmpty()) {
            int newindex = this.clampMode(modes.indexOf(this.getActiveMode(itemStack, player)) + 1, modes.size());
            return modes.get(newindex);
        }
        return "";
    }

    public String prevMode(ItemStack itemStack, EntityPlayer player) {
        List<String> modes = this.getValidModes(itemStack, player);
        if (!modes.isEmpty()) {
            int newindex = this.clampMode(modes.indexOf(this.getActiveMode(itemStack, player)) - 1, modes.size());
            return modes.get(newindex);
        }
        return "";
    }

    public List<String> getValidModes(ItemStack itemStack, EntityPlayer player) {
        return this.getValidModes(itemStack);
    }

    private int clampMode(int selection, int modesSize) {
        if (selection > 0) {
            return selection % modesSize;
        }
        return (selection + modesSize * -selection) % modesSize;
    }

    @Override
    public void cycleModeForItem(ItemStack itemStack, EntityPlayer player, int dMode) {
        if (itemStack != null) {
            this.cycleMode(itemStack, player, dMode);
        }
    }

    @Override
    public IIcon getModeIcon(String mode, ItemStack itemStack, EntityPlayer player) {
        if (!mode.isEmpty()) {
            return ModuleManager.getModule(mode).getIcon(itemStack);
        }
        return null;
    }

    @Override
    public List<String> getValidModes(ItemStack itemStack) {
        return ModuleManager.getValidModes(itemStack);
    }

    @Override
    public String getActiveMode(ItemStack itemStack) {
        String modeFromNBT = NuminaItemUtils.getTagCompound((ItemStack)itemStack).func_74779_i("mode");
        if (!modeFromNBT.isEmpty()) {
            return modeFromNBT;
        }
        List<String> validModes = this.getValidModes(itemStack);
        if (!validModes.isEmpty()) {
            return validModes.get(0);
        }
        return "";
    }
}

