/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.network.packets;

import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.network.MusePackager;
import net.machinemuse.numina.network.MusePacket;
import net.machinemuse.numina.network.PacketSender;
import net.machinemuse.powersuits.network.packets.MusePacketInventoryRefresh;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class MusePacketInstallModuleRequest
extends MusePacket {
    EntityPlayer player;
    int itemSlot;
    String moduleName;
    private static MusePacketInstallModuleRequestPackager PACKAGERINSTANCE;

    public MusePacketInstallModuleRequest(EntityPlayer player, int itemSlot, String moduleName) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.moduleName = moduleName;
    }

    public MusePackager packager() {
        return MusePacketInstallModuleRequest.getPackagerInstance();
    }

    public void write() {
        this.writeInt(this.itemSlot);
        this.writeString(this.moduleName);
    }

    public void handleServer(EntityPlayerMP player) {
        ItemStack stack = player.field_71071_by.func_70301_a(this.itemSlot);
        if (this.moduleName != null) {
            InventoryPlayer inventory = player.field_71071_by;
            IPowerModule moduleType = ModuleManager.getModule(this.moduleName);
            if (moduleType == null || !moduleType.isAllowed()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Server has disallowed this module. Sorry!"));
                return;
            }
            List<ItemStack> cost = moduleType.getInstallCost();
            if (!ModuleManager.itemHasModule(stack, this.moduleName) && MuseItemUtils.hasInInventory(cost, player.field_71071_by) || player.field_71075_bZ.field_75098_d) {
                ModuleManager.itemAddModule(stack, moduleType);
                for (ItemStack stackInCost : cost) {
                    ElectricItemUtils.givePlayerEnergy((EntityPlayer)player, ElectricItemUtils.jouleValueOfComponent(stackInCost));
                }
                List<Object> slotsToUpdate = new ArrayList<Integer>();
                if (!player.field_71075_bZ.field_75098_d) {
                    slotsToUpdate = MuseItemUtils.deleteFromInventory(cost, inventory);
                }
                slotsToUpdate.add(this.itemSlot);
                for (Integer n : slotsToUpdate) {
                    MusePacketInventoryRefresh reply = new MusePacketInventoryRefresh((EntityPlayer)player, n, inventory.func_70301_a(n.intValue()));
                    PacketSender.sendTo((MusePacket)reply, (EntityPlayerMP)player);
                }
            }
        }
    }

    public static MusePacketInstallModuleRequestPackager getPackagerInstance() {
        if (PACKAGERINSTANCE == null) {
            PACKAGERINSTANCE = new MusePacketInstallModuleRequestPackager();
        }
        return PACKAGERINSTANCE;
    }

    public static class MusePacketInstallModuleRequestPackager
    extends MusePackager {
        public MusePacket read(DataInputStream datain, EntityPlayer player) {
            int itemSlot = this.readInt(datain);
            String moduleName = this.readString(datain);
            return new MusePacketInstallModuleRequest(player, itemSlot, moduleName);
        }
    }
}

