/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.utils.ElectricItemUtils;
import net.machinemuse.utils.MPSTeleporter;
import net.machinemuse.utils.MuseHeatUtils;
import net.machinemuse.utils.MuseItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;

public class DimensionalRiftModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_DIMENSIONAL_RIFT = "Dimensional Tear Generator";
    public static final String DIMENSIONAL_RIFT_ENERGY_GENERATION = "Energy Consumption";
    public static final String DIMENSIONAL_RIFT_HEAT_GENERATION = "Heat Generation";

    public DimensionalRiftModule(List<IModularItem> validItems) {
        super(validItems);
        this.addBaseProperty(DIMENSIONAL_RIFT_HEAT_GENERATION, 55.0);
        this.addBaseProperty(DIMENSIONAL_RIFT_ENERGY_GENERATION, 20000.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
        this.defaultTag.func_74757_a("Active", false);
    }

    @Override
    public String getTextureFile() {
        return "kineticgen";
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getDataName() {
        return MODULE_DIMENSIONAL_RIFT;
    }

    @Override
    public String getUnlocalizedName() {
        return "dimRiftGen";
    }

    @Override
    public String getDescription() {
        return "Generate a tear in the space-time continuum that will teleport the player to its relative coordinates in the nether or overworld.";
    }

    @Override
    public void onRightClick(EntityPlayer playerClicking, World world, ItemStack item) {
        if (playerClicking.field_70154_o == null && playerClicking.field_70153_n == null && playerClicking instanceof EntityPlayerMP) {
            EntityPlayerMP thePlayer = (EntityPlayerMP)playerClicking;
            if (thePlayer.field_71093_bK != -1) {
                thePlayer.func_70012_b(0.5, thePlayer.field_70163_u, 0.5, thePlayer.field_70177_z, thePlayer.field_70125_A);
                thePlayer.field_71133_b.func_71203_ab().transferPlayerToDimension(thePlayer, -1, (Teleporter)new MPSTeleporter(thePlayer.field_71133_b.func_71218_a(-1)));
                ElectricItemUtils.drainPlayerEnergy((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(item, DIMENSIONAL_RIFT_ENERGY_GENERATION));
                MuseHeatUtils.heatPlayer((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(item, DIMENSIONAL_RIFT_HEAT_GENERATION));
            } else if (thePlayer.field_71093_bK == -1 || thePlayer.field_71093_bK == 1) {
                thePlayer.func_70012_b(0.5, thePlayer.field_70163_u, 0.5, thePlayer.field_70177_z, thePlayer.field_70125_A);
            }
            thePlayer.field_71133_b.func_71203_ab().transferPlayerToDimension(thePlayer, 0, (Teleporter)new MPSTeleporter(thePlayer.field_71133_b.func_71218_a(0)));
            if (thePlayer.field_71093_bK == 0) {
                ChunkCoordinates coords;
                ChunkCoordinates chunkCoordinates = coords = thePlayer instanceof EntityPlayer ? thePlayer.getBedLocation(thePlayer.field_71093_bK) : null;
                if (coords == null || coords.field_71574_a == 0 && coords.field_71572_b == 0 && coords.field_71573_c == 0) {
                    coords = world.func_72861_E();
                }
                int yPos = coords.field_71572_b;
                while (world.func_147439_a(coords.field_71574_a, yPos, coords.field_71573_c) != Blocks.field_150350_a && world.func_147439_a(coords.field_71574_a, yPos + 1, coords.field_71573_c) != Blocks.field_150350_a) {
                    ++yPos;
                }
                thePlayer.func_70634_a((double)coords.field_71574_a + 0.5, (double)yPos, (double)coords.field_71573_c + 0.5);
            }
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(item, DIMENSIONAL_RIFT_ENERGY_GENERATION));
            MuseHeatUtils.heatPlayer((EntityPlayer)thePlayer, ModuleManager.computeModularProperty(item, DIMENSIONAL_RIFT_HEAT_GENERATION));
        }
    }

    @Override
    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer player, int par4) {
    }
}

