/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemTag;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.powersuits.client.render.modelspec.DefaultModelSpec;
import net.machinemuse.powersuits.item.ItemComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MuseItemUtils {
    public static final String ONLINE = "Active";

    public static NBTTagCompound getMuseItemTag(ItemStack stack) {
        return MuseItemTag.getMuseItemTag(stack);
    }

    public static NBTTagCompound getMuseRenderTag(ItemStack stack, int armorSlot) {
        NBTTagCompound tag = MuseItemUtils.getMuseItemTag(stack);
        if (!tag.func_74764_b("render") || !(tag.func_74781_a("render") instanceof NBTTagCompound)) {
            MuseLogger.logDebug((String)"TAG BREACH IMMINENT, PLEASE HOLD ONTO YOUR SEATBELTS");
            tag.func_82580_o("render");
            tag.func_74782_a("render", (NBTBase)DefaultModelSpec.makeModelPrefs(stack, armorSlot));
        }
        return tag.func_74775_l("render");
    }

    public static NBTTagCompound getMuseRenderTag(ItemStack stack) {
        NBTTagCompound tag = MuseItemUtils.getMuseItemTag(stack);
        if (!tag.func_74764_b("render") || !(tag.func_74781_a("render") instanceof NBTTagCompound)) {
            tag.func_82580_o("render");
            tag.func_74782_a("render", (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l("render");
    }

    public static List<ItemStack> getModularItemsInInventory(IInventory inv) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static List<ItemStack> getModularItemsInInventory(EntityPlayer player) {
        return MuseItemUtils.getModularItemsInInventory((IInventory)player.field_71071_by);
    }

    public static List<Integer> getModularItemSlotsInInventory(IInventory inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static IModularItem getAsModular(Item item) {
        if (item instanceof IModularItem) {
            return (IModularItem)item;
        }
        return null;
    }

    public static boolean hasInInventory(List<ItemStack> workingUpgradeCost, InventoryPlayer inventory) {
        for (ItemStack stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.field_77994_a;
            }
            if (found >= stackInCost.field_77994_a) continue;
            return false;
        }
        return true;
    }

    public static List<Integer> deleteFromInventory(List<ItemStack> cost, InventoryPlayer inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ItemStack stackInCost : cost) {
            int remaining = stackInCost.field_77994_a;
            for (int i = 0; i < inventory.func_70302_i_() && remaining > 0; ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                int numToTake = Math.min(stackInInventory.field_77994_a, remaining);
                stackInInventory.field_77994_a -= numToTake;
                remaining -= numToTake;
                if (stackInInventory.field_77994_a == 0) {
                    inventory.func_70299_a(i, null);
                }
                slots.add(i);
            }
        }
        return slots;
    }

    public static List<Integer> findInInventoryForCost(List<ItemStack> workingUpgradeCost, InventoryPlayer inventory) {
        LinkedList<Integer> slots = new LinkedList<Integer>();
        for (ItemStack stackInCost : workingUpgradeCost) {
            int found = 0;
            for (int i = 0; i < inventory.func_70302_i_() && found < stackInCost.field_77994_a; ++i) {
                ItemStack stackInInventory = inventory.func_70301_a(i);
                if (!MuseItemUtils.isSameItem(stackInInventory, stackInCost)) continue;
                found += stackInInventory.field_77994_a;
                slots.add(i);
            }
        }
        return slots;
    }

    public static double getDoubleOrZero(NBTTagCompound itemProperties, String string) {
        double value = 0.0;
        if (itemProperties != null && itemProperties.func_74764_b(string)) {
            value = itemProperties.func_74769_h(string);
        }
        return value;
    }

    public static double getDoubleOrZero(ItemStack stack, String string) {
        return MuseItemUtils.getDoubleOrZero(MuseItemUtils.getMuseItemTag(stack), string);
    }

    public static void setDoubleOrRemove(NBTTagCompound itemProperties, String string, double value) {
        if (itemProperties != null) {
            if (value == 0.0) {
                itemProperties.func_82580_o(string);
            } else {
                itemProperties.func_74780_a(string, value);
            }
        }
    }

    public static void setDoubleOrRemove(ItemStack stack, String string, double value) {
        MuseItemUtils.setDoubleOrRemove(MuseItemUtils.getMuseItemTag(stack), string, value);
    }

    public static String getStringOrNull(NBTTagCompound itemProperties, String key) {
        String value = null;
        if (itemProperties != null && itemProperties.func_74764_b(key)) {
            value = itemProperties.func_74779_i(key);
        }
        return value;
    }

    public static String getStringOrNull(ItemStack stack, String key) {
        return MuseItemUtils.getStringOrNull(MuseItemUtils.getMuseItemTag(stack), key);
    }

    public static void setStringOrNull(NBTTagCompound itemProperties, String key, String value) {
        if (itemProperties != null) {
            if (value.isEmpty()) {
                itemProperties.func_82580_o(key);
            } else {
                itemProperties.func_74778_a(key, value);
            }
        }
    }

    public static void setStringOrNull(ItemStack stack, String key, String value) {
        MuseItemUtils.setStringOrNull(MuseItemUtils.getMuseItemTag(stack), key, value);
    }

    public static List<ItemStack> modularItemsEquipped(EntityPlayer player) {
        ItemStack[] equipped;
        ArrayList<ItemStack> modulars = new ArrayList<ItemStack>(5);
        for (ItemStack stack : equipped = MuseItemUtils.itemsEquipped(player)) {
            if (stack == null || !(stack.func_77973_b() instanceof IModularItem)) continue;
            modulars.add(stack);
        }
        return modulars;
    }

    public static ItemStack[] itemsEquipped(EntityPlayer player) {
        return new ItemStack[]{player.field_71071_by.field_70460_b[0], player.field_71071_by.field_70460_b[1], player.field_71071_by.field_70460_b[2], player.field_71071_by.field_70460_b[3], player.field_71071_by.func_70448_g()};
    }

    public static boolean canStackTogether(ItemStack stack1, ItemStack stack2) {
        if (!MuseItemUtils.isSameItem(stack1, stack2)) {
            return false;
        }
        if (!stack1.func_77985_e()) {
            return false;
        }
        return stack1.field_77994_a < stack1.func_77976_d();
    }

    public static boolean isSameItem(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        return stack1.func_77984_f() || stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static void transferStackWithChance(ItemStack itemsToGive, ItemStack destinationStack, double chanceOfSuccess) {
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.lvcapacitor)) {
            itemsToGive.field_77994_a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.mvcapacitor)) {
            itemsToGive.field_77994_a = 0;
            return;
        }
        if (MuseItemUtils.isSameItem(itemsToGive, ItemComponent.hvcapacitor)) {
            itemsToGive.field_77994_a = 0;
            return;
        }
        int maxSize = destinationStack.func_77976_d();
        while (itemsToGive.field_77994_a > 0 && destinationStack.field_77994_a < maxSize) {
            --itemsToGive.field_77994_a;
            if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
            ++destinationStack.field_77994_a;
        }
    }

    public static Set<Integer> giveOrDropItems(ItemStack itemsToGive, EntityPlayer player) {
        return MuseItemUtils.giveOrDropItemWithChance(itemsToGive, player, 1.0);
    }

    public static Set<Integer> giveOrDropItemWithChance(ItemStack itemsToGive, EntityPlayer player, double chanceOfSuccess) {
        int i;
        HashSet<Integer> slots = new HashSet<Integer>();
        for (i = 0; i < player.field_71071_by.func_70302_i_() && itemsToGive.field_77994_a > 0; ++i) {
            ItemStack currentStack = player.field_71071_by.func_70301_a(i);
            if (!MuseItemUtils.canStackTogether(currentStack, itemsToGive)) continue;
            slots.add(i);
            MuseItemUtils.transferStackWithChance(itemsToGive, currentStack, chanceOfSuccess);
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_() && itemsToGive.field_77994_a > 0; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            ItemStack destination = new ItemStack(itemsToGive.func_77973_b(), 0, itemsToGive.func_77960_j());
            MuseItemUtils.transferStackWithChance(itemsToGive, destination, chanceOfSuccess);
            if (destination.field_77994_a <= 0) continue;
            player.field_71071_by.func_70299_a(i, destination);
            slots.add(i);
        }
        if (itemsToGive.field_77994_a > 0) {
            for (i = 0; i < itemsToGive.field_77994_a; ++i) {
                if (!(MuseMathUtils.nextDouble() < chanceOfSuccess)) continue;
                ItemStack copyStack = itemsToGive.func_77946_l();
                copyStack.field_77994_a = 1;
                player.func_71019_a(copyStack, false);
            }
        }
        return slots;
    }

    public static double getPlayerWeight(EntityPlayer player) {
        double weight = 0.0;
        for (ItemStack stack : MuseItemUtils.modularItemsEquipped(player)) {
            weight += ModuleManager.computeModularProperty(stack, "Weight");
        }
        return weight;
    }

    public static List<IPowerModule> getPlayerInstalledModules(EntityPlayer player) {
        ArrayList<IPowerModule> installedModules = new ArrayList<IPowerModule>();
        for (ItemStack stack : MuseItemUtils.modularItemsEquipped(player)) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            for (IPowerModule module : ModuleManager.getValidModulesForItem(player, stack)) {
                if (!ModuleManager.tagHasModule(itemTag, module.getDataName())) continue;
                installedModules.add(module);
            }
        }
        return installedModules;
    }

    public static void toggleModuleForPlayer(EntityPlayer player, String name, boolean toggleval) {
        for (ItemStack stack : MuseItemUtils.modularItemsEquipped(player)) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            ModuleManager.toggleModule(itemTag, name, toggleval);
        }
    }

    public static ItemStack copyAndResize(ItemStack stack, int number) {
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = number;
        return copy;
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        int i;
        for (i = 0; i < player.field_71071_by.func_70302_i_() - 4; ++i) {
            if (player.field_71071_by.func_70301_a(i) != null) continue;
            return true;
        }
        if (!itemstack.func_77951_h()) {
            if (itemstack.func_77976_d() == 1) {
                return false;
            }
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack invstack = player.field_71071_by.func_70301_a(i);
                if (invstack == null || invstack.func_77973_b() != itemstack.func_77973_b() || !invstack.func_77985_e() || invstack.field_77994_a >= invstack.func_77976_d() || invstack.field_77994_a >= player.field_71071_by.func_70297_j_() || invstack.func_77981_g() && invstack.func_77960_j() != itemstack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    public static double getFoodLevel(ItemStack stack) {
        NBTTagCompound itemTag;
        Double foodLevel;
        if (stack != null && stack.func_77973_b() instanceof IModularItem && (foodLevel = Double.valueOf((itemTag = MuseItemUtils.getMuseItemTag(stack)).func_74769_h("Food"))) != null) {
            return foodLevel;
        }
        return 0.0;
    }

    public static void setFoodLevel(ItemStack stack, double d) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74780_a("Food", d);
        }
    }

    public static double getSaturationLevel(ItemStack stack) {
        NBTTagCompound itemTag;
        Double saturationLevel;
        if (stack != null && stack.func_77973_b() instanceof IModularItem && (saturationLevel = Double.valueOf((itemTag = MuseItemUtils.getMuseItemTag(stack)).func_74769_h("Saturation"))) != null) {
            return saturationLevel;
        }
        return 0.0;
    }

    public static void setSaturationLevel(ItemStack stack, double d) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74780_a("Saturation", d);
        }
    }

    public static int getTorchLevel(ItemStack stack) {
        NBTTagCompound itemTag;
        Integer torchLevel;
        if (stack != null && stack.func_77973_b() instanceof IModularItem && (torchLevel = Integer.valueOf((itemTag = MuseItemUtils.getMuseItemTag(stack)).func_74762_e("Torch"))) != null) {
            return torchLevel;
        }
        return 0;
    }

    public static void setTorchLevel(ItemStack stack, int i) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74768_a("Torch", i);
        }
    }

    public static double getWaterLevel(ItemStack stack) {
        NBTTagCompound itemTag;
        Double waterLevel;
        if (stack != null && stack.func_77973_b() instanceof IModularItem && (waterLevel = Double.valueOf((itemTag = MuseItemUtils.getMuseItemTag(stack)).func_74769_h("Water"))) != null) {
            return waterLevel;
        }
        return 0.0;
    }

    public static void setWaterLevel(ItemStack stack, double d) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74780_a("Water", d);
        }
    }

    public static void setLiquid(ItemStack stack, String name) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74778_a("Liquid", name);
        }
    }

    public static String getLiquid(ItemStack stack) {
        NBTTagCompound itemTag;
        String s;
        if (stack != null && stack.func_77973_b() instanceof IModularItem && (s = (itemTag = MuseItemUtils.getMuseItemTag(stack)).func_74779_i("Liquid")) != null) {
            return s;
        }
        return "";
    }

    public static int getCoalLevel(ItemStack stack) {
        NBTTagCompound itemTag;
        Integer coalLevel;
        if (stack != null && stack.func_77973_b() instanceof IModularItem && (coalLevel = Integer.valueOf((itemTag = MuseItemUtils.getMuseItemTag(stack)).func_74762_e("Coal"))) != null) {
            return coalLevel;
        }
        return 0;
    }

    public static void setCoalLevel(ItemStack stack, int i) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74768_a("Coal", i);
        }
    }

    public static String getEIONoCompete(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            if (itemTag != null) {
                return itemTag.func_74779_i("eioNoCompete");
            }
            return "";
        }
        return "";
    }

    public static void setEIONoCompete(ItemStack stack, String s) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74778_a("eioNoCompete", s);
        }
    }

    public static boolean getEIOFacadeTransparency(ItemStack stack) {
        NBTTagCompound itemTag;
        if (stack != null && stack.func_77973_b() instanceof IModularItem && (itemTag = MuseItemUtils.getMuseItemTag(stack)) != null) {
            return itemTag.func_74767_n("eioFacadeTransparency");
        }
        return false;
    }

    public static void setEIOFacadeTransparency(ItemStack stack, boolean b) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = MuseItemUtils.getMuseItemTag(stack);
            itemTag.func_74757_a("eioFacadeTransparency", b);
        }
    }

    public static NBTTagCompound getFluidTermTag(ItemStack stack) {
        NBTTagCompound ret = null;
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            ret = MuseItemUtils.getMuseItemTag(stack).func_74775_l("AppEng EC Wireless Fluid Terminal");
        }
        return ret;
    }

    public static void setFluidTermTag(ItemStack stack, NBTTagCompound tag) {
        NBTTagCompound t = MuseItemUtils.getMuseItemTag(stack);
        t.func_74782_a("AppEng EC Wireless Fluid Terminal", (NBTBase)tag);
        stack.field_77990_d.func_74782_a("mmmpsmod", (NBTBase)t);
    }

    public static boolean getCanShrink(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound cmTag;
            NBTTagCompound itemTag = stack.func_77978_p();
            NBTTagCompound nBTTagCompound = cmTag = itemTag.func_74764_b("CompactMachines") ? itemTag.func_74775_l("CompactMachines") : null;
            if (cmTag != null && cmTag.func_74764_b("canShrink")) {
                return cmTag.func_74767_n("canShrink");
            }
        }
        return false;
    }

    public static void setCanShrink(ItemStack stack, boolean b) {
        if (stack != null && stack.func_77973_b() instanceof IModularItem) {
            NBTTagCompound itemTag = stack.field_77990_d;
            NBTTagCompound cmTag = itemTag.func_74764_b("CompactMachines") ? itemTag.func_74775_l("CompactMachines") : new NBTTagCompound();
            cmTag.func_74757_a("canShrink", b);
            itemTag.func_74782_a("CompactMachines", (NBTBase)cmTag);
        }
    }

    public static NBTTagCompound getNBTTag(ItemStack itemStack) {
        NBTTagCompound tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.func_77982_d(tag);
        }
        return tag;
    }

    public static boolean isClientWorld(World world) {
        return world.field_72995_K;
    }

    public static boolean isServerWorld(World world) {
        return !world.field_72995_K;
    }

    public static boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isServerSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }
}

