/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.utils;

import java.lang.reflect.Field;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.general.MuseMathUtils;
import net.machinemuse.numina.player.NuminaPlayerUtils;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.control.PlayerInputMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class MusePlayerUtils {
    static final double root2 = Math.sqrt(2.0);
    protected static Field movementfactorfieldinstance;

    public static MovingObjectPosition raytraceEntities(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        MovingObjectPosition pickedEntity = null;
        Vec3 playerPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 playerLook = player.func_70040_Z();
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance));
        double playerBorder = 1.1 * reachDistance;
        AxisAlignedBB boxToScan = player.field_70121_D.func_72314_b(playerBorder, playerBorder, playerBorder);
        List entitiesHit = world.func_72839_b((Entity)player, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            float border;
            AxisAlignedBB aabb;
            MovingObjectPosition hitMOP;
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.field_70121_D == null || (hitMOP = (aabb = entityHit.field_70121_D.func_72314_b((double)(border = entityHit.func_70111_Y()), (double)border, (double)border)).func_72327_a(playerPosition, playerViewOffset)) == null) continue;
            if (aabb.func_72318_a(playerPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new MovingObjectPosition(entityHit)) == null) continue;
                pickedEntity.field_72307_f = hitMOP.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = playerPosition.func_72438_d(hitMOP.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new MovingObjectPosition(entityHit);
            pickedEntity.field_72307_f = hitMOP.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public static MovingObjectPosition raytraceBlocks(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        Vec3 playerPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        Vec3 playerLook = player.func_70040_Z();
        Vec3 playerViewOffset = Vec3.func_72443_a((double)(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance), (double)(playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance), (double)(playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance));
        return world.func_72933_a(playerPosition, playerViewOffset);
    }

    public static MovingObjectPosition doCustomRayTrace(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        MovingObjectPosition pickedBlock = MusePlayerUtils.raytraceBlocks(world, player, collisionFlag, reachDistance);
        MovingObjectPosition pickedEntity = MusePlayerUtils.raytraceEntities(world, player, collisionFlag, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        Vec3 playerPosition = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        double dBlock = pickedBlock.field_72307_f.func_72438_d(playerPosition);
        double dEntity = pickedEntity.field_72307_f.func_72438_d(playerPosition);
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public static void teleportEntity(EntityPlayer entityPlayer, MovingObjectPosition hitMOP) {
        if (hitMOP != null && entityPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
            if (player.field_71135_a.field_147371_a.func_150724_d()) {
                switch (hitMOP.field_72313_a) {
                    case ENTITY: {
                        player.func_70634_a(hitMOP.field_72307_f.field_72450_a, hitMOP.field_72307_f.field_72448_b, hitMOP.field_72307_f.field_72449_c);
                        break;
                    }
                    case BLOCK: {
                        double hitx = hitMOP.field_72307_f.field_72450_a;
                        double hity = hitMOP.field_72307_f.field_72448_b;
                        double hitz = hitMOP.field_72307_f.field_72449_c;
                        switch (hitMOP.field_72310_e) {
                            case 0: {
                                hity -= 2.0;
                                break;
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                hitz -= 0.5;
                                break;
                            }
                            case 3: {
                                hitz += 0.5;
                                break;
                            }
                            case 4: {
                                hitx -= 0.5;
                                break;
                            }
                            case 5: {
                                hitx += 0.5;
                            }
                        }
                        player.func_70634_a(hitx, hity, hitz);
                        break;
                    }
                }
            }
        }
    }

    public static double thrust(EntityPlayer player, double thrust, boolean flightControl) {
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.func_70005_c_());
        boolean jumpkey = movementInput.jumpKey;
        float forwardkey = movementInput.forwardKey;
        float strafekey = movementInput.strafeKey;
        boolean downkey = movementInput.downKey;
        boolean sneakkey = movementInput.sneakKey;
        double thrustUsed = 0.0;
        if (flightControl) {
            Vec3 desiredDirection = player.func_70040_Z().func_72432_b();
            double strafeX = desiredDirection.field_72449_c;
            double strafeZ = -desiredDirection.field_72450_a;
            double scaleStrafe = strafeX * strafeX + strafeZ * strafeZ;
            double flightVerticality = 0.0;
            ItemStack helm = player.func_82169_q(3);
            if (helm != null && helm.func_77973_b() instanceof IModularItem) {
                flightVerticality = ModuleManager.computeModularProperty(helm, "Y-look ratio");
            }
            desiredDirection.field_72450_a = desiredDirection.field_72450_a * (double)Math.signum(forwardkey) + strafeX * (double)Math.signum(strafekey);
            desiredDirection.field_72448_b = flightVerticality * desiredDirection.field_72448_b * (double)Math.signum(forwardkey) + (double)(jumpkey ? 1 : 0) - (double)(downkey ? 1 : 0);
            desiredDirection.field_72449_c = desiredDirection.field_72449_c * (double)Math.signum(forwardkey) + strafeZ * (double)Math.signum(strafekey);
            desiredDirection = desiredDirection.func_72432_b();
            if (player.field_70181_x < 0.0 && desiredDirection.field_72448_b >= 0.0) {
                if (-player.field_70181_x > thrust) {
                    player.field_70181_x += thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= player.field_70181_x;
                    thrustUsed += player.field_70181_x;
                    player.field_70181_x = 0.0;
                }
            }
            if (player.field_70181_x < -1.0) {
                thrust += 1.0 + player.field_70181_x;
                thrustUsed -= 1.0 + player.field_70181_x;
                player.field_70181_x = -1.0;
            }
            if (Math.abs(player.field_70159_w) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.field_70159_w) > thrust) {
                    player.field_70159_w -= Math.signum(player.field_70159_w) * thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrust -= Math.abs(player.field_70159_w);
                    thrustUsed += Math.abs(player.field_70159_w);
                    player.field_70159_w = 0.0;
                }
            }
            if (Math.abs(player.field_70179_y) > 0.0 && desiredDirection.func_72433_c() == 0.0) {
                if (Math.abs(player.field_70179_y) > thrust) {
                    player.field_70179_y -= Math.signum(player.field_70179_y) * thrust;
                    thrustUsed += thrust;
                    thrust = 0.0;
                } else {
                    thrustUsed += Math.abs(player.field_70179_y);
                    thrust -= Math.abs(player.field_70179_y);
                    player.field_70179_y = 0.0;
                }
            }
            double vx = thrust * desiredDirection.field_72450_a;
            double vy = thrust * desiredDirection.field_72448_b;
            double vz = thrust * desiredDirection.field_72449_c;
            player.field_70159_w += vx;
            player.field_70181_x += vy;
            player.field_70179_y += vz;
            thrustUsed += thrust;
        } else {
            Vec3 playerHorzFacing = player.func_70040_Z();
            playerHorzFacing.field_72448_b = 0.0;
            playerHorzFacing.func_72432_b();
            if (forwardkey == 0.0f) {
                player.field_70181_x += thrust;
            } else {
                player.field_70181_x += thrust / root2;
                player.field_70159_w += playerHorzFacing.field_72450_a * thrust / root2 * (double)Math.signum(forwardkey);
                player.field_70179_y += playerHorzFacing.field_72449_c * thrust / root2 * (double)Math.signum(forwardkey);
            }
            thrustUsed += thrust;
        }
        double horzm2 = player.field_70159_w * player.field_70159_w + player.field_70179_y * player.field_70179_y;
        double horzmlim = Config.getMaximumFlyingSpeedmps() * Config.getMaximumFlyingSpeedmps() / 400.0;
        if (sneakkey && horzmlim > 0.05) {
            horzmlim = 0.05;
        }
        if (horzm2 > horzmlim) {
            double ratio = Math.sqrt(horzmlim / horzm2);
            player.field_70159_w *= ratio;
            player.field_70179_y *= ratio;
        }
        NuminaPlayerUtils.resetFloatKickTicks((EntityPlayer)player);
        return thrustUsed;
    }

    public static double getWeightPenaltyRatio(double currentWeight, double capacity) {
        if (currentWeight < capacity) {
            return 1.0;
        }
        return capacity / currentWeight;
    }

    public static EntityPlayer toPlayer(Object data) {
        EntityPlayer player = null;
        try {
            player = (EntityPlayer)data;
        }
        catch (ClassCastException e) {
            MuseLogger.logError((String)"MMMPS: Player tick handler received invalid Player object");
            e.printStackTrace();
        }
        return player;
    }

    public static double getPlayerCoolingBasedOnMaterial(EntityPlayer player) {
        double cool = 0.0;
        if (player.func_70090_H()) {
            cool += 0.5;
        } else if (player.func_70055_a(Material.field_151587_i)) {
            return 0.0;
        }
        cool += (2.0 - (double)MusePlayerUtils.getBiome(player).func_150564_a((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) / 2.0;
        if ((int)player.field_70163_u > 128) {
            cool += 0.5;
        }
        if (!player.field_70170_p.func_72935_r() && "Desert".equals(MusePlayerUtils.getBiome((EntityPlayer)player).field_76791_y)) {
            cool += 0.8;
        }
        if (player.field_70170_p.func_72896_J()) {
            cool += 0.2;
        }
        return cool;
    }

    public static BiomeGenBase getBiome(EntityPlayer player) {
        Chunk chunk = player.field_70170_p.func_72938_d((int)player.field_70165_t, (int)player.field_70161_v);
        return chunk.func_76591_a((int)player.field_70165_t & 0xF, (int)player.field_70161_v & 0xF, player.field_70170_p.func_72959_q());
    }

    public static void setFOVMult(EntityPlayer player, float fovmult) {
        Field movementfactor = MusePlayerUtils.getMovementFactorField();
        try {
            movementfactor.set(player, Float.valueOf(fovmult));
        }
        catch (IllegalAccessException e) {
            MuseLogger.logDebug((String)"illegalAccessException");
        }
    }

    public static Field getMovementFactorField() {
        if (movementfactorfieldinstance == null) {
            try {
                movementfactorfieldinstance = EntityPlayer.class.getDeclaredField("speedOnGround");
                movementfactorfieldinstance.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                try {
                    movementfactorfieldinstance = EntityPlayer.class.getDeclaredField("field_71108_cd");
                    movementfactorfieldinstance.setAccessible(true);
                }
                catch (NoSuchFieldException e1) {
                    try {
                        movementfactorfieldinstance = EntityPlayer.class.getDeclaredField("ci");
                        movementfactorfieldinstance.setAccessible(true);
                    }
                    catch (NoSuchFieldException e2) {
                        MuseLogger.logDebug((String)"Getting failed");
                    }
                }
            }
        }
        return movementfactorfieldinstance;
    }

    public static double computePlayerVelocity(EntityPlayer entityPlayer) {
        return MuseMathUtils.pythag((double)entityPlayer.field_70159_w, (double)entityPlayer.field_70181_x, (double)entityPlayer.field_70179_y);
    }
}

