/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.jei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import net.machinemuse.numina.recipe.ItemNameMappings;
import net.machinemuse.numina.recipe.JSONRecipe;
import net.machinemuse.numina.recipe.SimpleItemMatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class JEINuminaWrapper
extends BlankRecipeWrapper
implements ICraftingRecipeWrapper {
    private final JSONRecipe recipe;
    private static Map<String, ArrayList<ItemStack>> itemMap;

    public JEINuminaWrapper(JSONRecipe recipe) {
        this.recipe = recipe;
    }

    public int getHeight() {
        return this.recipe.ingredients.length;
    }

    public int getWidth() {
        return this.recipe.getWidth();
    }

    public List getInputs() {
        int height = this.recipe.ingredients.length;
        int width = this.recipe.getWidth();
        if (height == 0 || width == 0) {
            return null;
        }
        ArrayList<List<ItemStack>> ret = new ArrayList<List<ItemStack>>();
        for (int y = 0; y < height; ++y) {
            if (this.recipe.ingredients[y] == null) continue;
            for (int x = 0; x < width; ++x) {
                List<ItemStack> item = this.recipe.ingredients[y].length > x ? JEINuminaWrapper.getIngredient(this.recipe.ingredients[y][x]) : null;
                if (item != null && item.isEmpty()) {
                    return null;
                }
                ret.add(item);
            }
        }
        return ret;
    }

    public List getOutputs() {
        return Collections.singletonList(this.recipe.func_77571_b());
    }

    public static List<ItemStack> getIngredient(SimpleItemMatcher cell) {
        String[] names;
        ArrayList<ItemStack> t;
        Boolean shouldbenull = true;
        ArrayList<Object> result = null;
        if (cell == null) {
            return null;
        }
        if (cell.oredictName != null) {
            shouldbenull = false;
            result = OreDictionary.getOres((String)cell.oredictName);
            if (cell.meta != null && result != null && cell.meta != Short.MAX_VALUE) {
                t = new ArrayList();
                for (ItemStack itemStack : result) {
                    if (cell.meta.intValue() != itemStack.func_77952_i()) continue;
                    t.add(itemStack);
                }
                result = t;
            }
        }
        if (cell.itemStackName != null) {
            shouldbenull = false;
            names = cell.itemStackName.split(":");
            result = new ArrayList<ItemStack>();
            ItemStack stack = new ItemStack(GameRegistry.findItem((String)names[0], (String)names[1]), 1);
            if (stack != null) {
                stack = stack.func_77946_l();
                if (cell.meta != null) {
                    stack.func_77964_b(cell.meta.intValue());
                }
                result.add(stack);
            }
        }
        if (cell.registryName != null) {
            shouldbenull = false;
            names = cell.registryName.split(":");
            result = new ArrayList();
            Item item = GameRegistry.findItem((String)names[0], (String)names[1]);
            if (item != null) {
                int n = cell.meta == null ? 0 : cell.meta;
                ItemStack stack = new ItemStack(item, 1, n);
                result.add(stack);
            }
        }
        if (cell.unlocalizedName != null) {
            shouldbenull = false;
            if (result == null) {
                result = JEINuminaWrapper.getItemByUnlocalizedName(cell.unlocalizedName);
            } else {
                t = new ArrayList<ItemStack>();
                for (ItemStack itemStack : result) {
                    if (!cell.unlocalizedName.equals(itemStack.func_77973_b().func_77667_c(itemStack))) continue;
                    t.add(itemStack);
                }
                result = t;
            }
        }
        if (cell.nbtString != null && result != null) {
            shouldbenull = false;
            t = new ArrayList();
            for (ItemStack itemStack : result) {
                ItemStack stack2 = itemStack.func_77946_l();
                try {
                    stack2.func_77982_d(JsonToNBT.func_180713_a((String)cell.nbtString));
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
                t.add(stack2);
            }
            result = t;
        }
        if (!(shouldbenull.booleanValue() || result != null && result.size() != 0)) {
            System.out.println("cell should not be null but it is");
            System.out.println("cell.oredictName: " + cell.oredictName);
            System.out.println("cell.itemStackName: " + cell.itemStackName);
            System.out.println("cell.registryName: " + cell.registryName);
            System.out.println("cell.unlocalizedName: " + cell.unlocalizedName);
            System.out.println("cell.nbtString: " + cell.nbtString);
        }
        return result;
    }

    public static ArrayList<ItemStack> getItemByUnlocalizedName(String unlocalizedName) {
        ItemStack stack;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (itemMap == null && (stack = ItemNameMappings.getItem(unlocalizedName)) != null) {
            result.add(stack);
        }
        if (itemMap != null && itemMap.containsKey(unlocalizedName)) {
            result.addAll((Collection<ItemStack>)itemMap.get(unlocalizedName));
        }
        return result;
    }
}

