/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.recipe;

import net.machinemuse.numina.general.MuseLogger;
import net.machinemuse.numina.recipe.IItemMaker;
import net.machinemuse.numina.recipe.ItemNameMappings;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class SimpleItemMaker
implements IItemMaker {
    public Integer meta;
    public Integer quantity;
    public String unlocalizedName;
    public String oredictName;
    public String registryName;
    public String itemStackName;
    public String nbtString;

    @Override
    public ItemStack makeItem(InventoryCrafting i) {
        return this.getRecipeOutput();
    }

    private int getOrElse(Integer input, int defaultval) {
        if (input == null) {
            return defaultval;
        }
        return input;
    }

    @Override
    public ItemStack getRecipeOutput() {
        int newmeta = this.getOrElse(this.meta, 0);
        int newquantity = this.getOrElse(this.quantity, 1);
        NBTTagCompound nbt = null;
        if (this.nbtString != null) {
            try {
                nbt = JsonToNBT.func_180713_a((String)this.nbtString);
            }
            catch (Exception e) {
                MuseLogger.logException("Bad NBT string in item! Attempting to create generic item instead.", e);
            }
        }
        if (this.itemStackName != null) {
            try {
                String[] names = this.itemStackName.split(":");
                ItemStack stack = new ItemStack(GameRegistry.findItem((String)names[0], (String)names[1]), newquantity);
                if (this.meta != null) {
                    stack.func_77964_b(this.meta.intValue());
                }
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.itemStackName + " from Item Registry");
                return null;
            }
        }
        if (this.registryName != null) {
            try {
                String[] names = this.registryName.split(":");
                ItemStack stack = new ItemStack(GameRegistry.findItem((String)names[0], (String)names[1]), newquantity, newmeta);
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.registryName + " from Item Registry");
                return null;
            }
        }
        if (this.oredictName != null) {
            try {
                ItemStack stack = ((ItemStack)OreDictionary.getOres((String)this.oredictName).get(0)).func_77946_l();
                stack.field_77994_a = Math.min(newquantity, stack.func_77976_d());
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.oredictName + " from oredict");
                return null;
            }
        }
        if (this.unlocalizedName != null) {
            MuseLogger.logError("WARNING: unlocalizedName is deprecated; please use registryName or itemStackName instead!");
            try {
                ItemStack stack = ItemNameMappings.getItem(this.unlocalizedName).func_77946_l();
                newmeta = this.getOrElse(this.meta, stack.func_77952_i());
                stack.func_77964_b(newmeta);
                stack.field_77994_a = Math.min(newquantity, stack.func_77976_d());
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                return stack;
            }
            catch (Exception e) {
                MuseLogger.logError("Unable to load " + this.unlocalizedName + " from unlocalized names");
                return null;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleItemMaker)) {
            return false;
        }
        SimpleItemMaker other = (SimpleItemMaker)obj;
        if (!this.compareInteger(this.meta, other.meta)) {
            return false;
        }
        if (!this.compareInteger(this.quantity, other.quantity)) {
            return false;
        }
        if (!this.compareString(this.unlocalizedName, other.unlocalizedName)) {
            return false;
        }
        if (!this.compareString(this.oredictName, other.oredictName)) {
            return false;
        }
        if (!this.compareString(this.registryName, other.registryName)) {
            return false;
        }
        if (!this.compareString(this.itemStackName, other.itemStackName)) {
            return false;
        }
        return this.compareString(this.nbtString, other.nbtString);
    }

    private boolean compareInteger(Integer a, Integer b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.intValue() == b.intValue();
    }

    private boolean compareString(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }
}

