/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.block;

import java.util.Random;
import net.machinemuse.powersuits.block.TileEntityLuxCapacitor;
import net.machinemuse.powersuits.common.Config;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLuxCapacitor
extends Block {
    protected int renderType;
    public static final IProperty FACING = PropertyDirection.func_177714_a((String)"facing");

    public BlockLuxCapacitor() {
        super(Material.field_151594_q);
        this.func_149647_a(Config.getCreativeTab());
        this.func_149711_c(0.05f);
        this.func_149752_b(10.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149713_g(0);
        this.func_149715_a(1.0f);
        this.func_149675_a(false);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149663_c("luxCapacitor");
        this.setRenderType(3);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public BlockLuxCapacitor setRenderType(int id) {
        this.renderType = id;
        return this;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a(FACING, (Comparable)facing);
    }

    private static float bbMin(double offset) {
        return (float)(offset > 0.0 ? 13 : (offset < 0.0 ? 0 : 1)) / 16.0f;
    }

    private static float bbMax(double offset) {
        return (float)(offset > 0.0 ? 16 : (offset < 0.0 ? 3 : 15)) / 16.0f;
    }

    public static AxisAlignedBB createAABBForSide(EnumFacing dir, BlockPos pos) {
        double x1 = BlockLuxCapacitor.bbMin(dir.func_82601_c());
        double y1 = BlockLuxCapacitor.bbMin(dir.func_96559_d());
        double z1 = BlockLuxCapacitor.bbMin(dir.func_82599_e());
        double x2 = BlockLuxCapacitor.bbMax(dir.func_82601_c());
        double y2 = BlockLuxCapacitor.bbMax(dir.func_96559_d());
        double z2 = BlockLuxCapacitor.bbMax(dir.func_82599_e());
        return AxisAlignedBB.func_178781_a((double)((double)pos.func_177958_n() + x1), (double)((double)pos.func_177956_o() + y1), (double)((double)pos.func_177952_p() + z1), (double)((double)pos.func_177958_n() + x2), (double)((double)pos.func_177956_o() + y2), (double)((double)pos.func_177952_p() + z2));
    }

    public int func_149645_b() {
        return this.renderType;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityLuxCapacitor();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityLuxCapacitor) {
            EnumFacing side = ((TileEntityLuxCapacitor)te).side;
            return BlockLuxCapacitor.createAABBForSide(side, pos);
        }
        return null;
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityLuxCapacitor) {
            EnumFacing side = ((TileEntityLuxCapacitor)te).side;
            return BlockLuxCapacitor.createAABBForSide(side, pos);
        }
        return null;
    }

    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityLuxCapacitor) {
            EnumFacing side = ((TileEntityLuxCapacitor)te).side;
            float x1 = BlockLuxCapacitor.bbMin(side.func_82601_c());
            float y1 = BlockLuxCapacitor.bbMin(side.func_96559_d());
            float z1 = BlockLuxCapacitor.bbMin(side.func_82599_e());
            float x2 = BlockLuxCapacitor.bbMax(side.func_82601_c());
            float y2 = BlockLuxCapacitor.bbMax(side.func_96559_d());
            float z2 = BlockLuxCapacitor.bbMax(side.func_82599_e());
            this.func_149676_a(x1, y1, z1, x2, y2, z2);
        }
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public boolean func_149698_L() {
        return false;
    }
}

