/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.machinemuse.powersuits.client.render.OBJModel;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class OBJLoader
implements ICustomModelLoader {
    public static final OBJLoader instance = new OBJLoader();
    private IResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, OBJModel> cache = new HashMap<ResourceLocation, OBJModel>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log((Level)Level.INFO, (String)"OBJLoader: Domain %s has been added.", (Object[])new Object[]{domain.toLowerCase()});
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.manager = resourceManager;
        this.cache.clear();
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b()) && modelLocation.func_110623_a().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        OBJModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file)) {
            try {
                IResource resource = null;
                try {
                    if (this.manager == null) {
                        System.out.println("manager is null!!");
                    }
                    resource = this.manager.func_110536_a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.func_110623_a().startsWith("models/block/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                    }
                    if (modelLocation.func_110623_a().startsWith("models/item/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                    }
                    throw e;
                }
                OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
                OBJModel model2 = null;
                try {
                    model2 = parser.parse();
                }
                finally {
                    this.cache.put(modelLocation, model2);
                }
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Exception loading model '%s' with OBJ loader, skipping", (Object[])new Object[]{modelLocation});
                throw e;
            }
        }
        if ((model = this.cache.get(modelLocation)) == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        return model;
    }
}

