/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.render.entity;

import com.google.common.base.Function;
import java.io.IOException;
import java.util.List;
import net.machinemuse.numina.render.MuseTextureUtils;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.entity.EntityLuxCapacitor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import org.lwjgl.opengl.GL11;

public class RenderLuxCapacitorEntity
extends Render<EntityLuxCapacitor> {
    private static IModel luxcapacitormodel;
    private static IBakedModel bakedluxcapacitormodel;
    protected static ResourceLocation texture;
    Tessellator tessellator = Tessellator.func_178181_a();
    WorldRenderer worldRenderer = this.tessellator.func_178180_c();
    static Function<ResourceLocation, TextureAtlasSprite> textureGetter;

    public RenderLuxCapacitorEntity(RenderManager renderManager) {
        super(renderManager);
        luxcapacitormodel = this.getLuxCapacitorModel();
        bakedluxcapacitormodel = this.getBakedLuxCapacitorModel();
    }

    private static IModel getLuxCapacitorModel() {
        if (luxcapacitormodel == null) {
            try {
                luxcapacitormodel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(ModularPowersuits.MODID(), "block/luxCapacitorModel"));
            }
            catch (IOException e) {
                e.printStackTrace();
                luxcapacitormodel = ModelLoaderRegistry.getMissingModel();
            }
        }
        return luxcapacitormodel;
    }

    private static IBakedModel getBakedLuxCapacitorModel() {
        if (bakedluxcapacitormodel == null) {
            bakedluxcapacitormodel = RenderLuxCapacitorEntity.getLuxCapacitorModel().bake((IModelState)TRSRTransformation.identity(), Attributes.DEFAULT_BAKED_FORMAT, textureGetter);
        }
        return bakedluxcapacitormodel;
    }

    private void modelRender(IBakedModel bakedmodel) {
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        List generalQuads = bakedmodel.func_177550_a();
        for (BakedQuad q : generalQuads) {
            int[] vd = q.func_178209_a();
            this.worldRenderer.func_178981_a(vd);
        }
        for (EnumFacing face : EnumFacing.values()) {
            List faceQuads = bakedmodel.func_177551_a(face);
            for (BakedQuad q : faceQuads) {
                int[] vd = q.func_178209_a();
                this.worldRenderer.func_178981_a(vd);
            }
        }
        this.tessellator.func_78381_a();
    }

    protected ResourceLocation getEntityTexture(EntityLuxCapacitor entity) {
        return texture;
    }

    public void doRender(EntityLuxCapacitor entity, double x, double y, double z, float entityYaw, float partialTicks) {
        MuseTextureUtils.pushTexture((String)(Config.TEXTURE_PREFIX() + "blocks/models/luxcapent.png"));
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.modelRender(RenderLuxCapacitorEntity.getBakedLuxCapacitorModel());
        GL11.glPopMatrix();
        MuseTextureUtils.popTexture();
    }

    static {
        texture = new ResourceLocation(Config.TEXTURE_PREFIX() + "blocks/models/luxcapent.png");
        textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation location) {
                TextureAtlasSprite abc = Minecraft.func_71410_x().func_147117_R().func_110572_b(Config.TEXTURE_PREFIX() + "blocks/models/thusters_uvw_1");
                return abc;
            }
        };
    }
}

