/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import java.util.Collections;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.MPSItems;
import net.machinemuse.powersuits.powermodule.misc.ThaumGogglesModule;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModAPIManager;

public class ModCompatibility {
    public static boolean isGregTechLoaded() {
        return Loader.isModLoaded((String)"gregtech_addon");
    }

    public static boolean isIndustrialCraftLoaded() {
        return Loader.isModLoaded((String)"IC2");
    }

    public static boolean isThaumCraftLoaded() {
        return Loader.isModLoaded((String)"Thaumcraft");
    }

    public static boolean isThermalExpansionLoaded() {
        return Loader.isModLoaded((String)"ThermalExpansion");
    }

    public static boolean isGalacticraftLoaded() {
        return Loader.isModLoaded((String)"GalacticraftCore");
    }

    public static boolean isRFAPILoaded() {
        return ModAPIManager.INSTANCE.hasAPI("CoFHAPI|energy");
    }

    public static boolean isForestryLoaded() {
        return Loader.isModLoaded((String)"Forestry");
    }

    public static boolean isChiselLoaded() {
        return Loader.isModLoaded((String)"chisel");
    }

    public static boolean isEnderIOLoaded() {
        return Loader.isModLoaded((String)"EnderIO");
    }

    public static boolean isAppengLoaded() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }

    public static boolean isExtraCellsLoaded() {
        return Loader.isModLoaded((String)"extracells");
    }

    public static boolean isMFRLoaded() {
        return Loader.isModLoaded((String)"MineFactoryReloaded");
    }

    public static boolean isRailcraftLoaded() {
        return Loader.isModLoaded((String)"Railcraft");
    }

    public static boolean isCompactMachinesLoaded() {
        return Loader.isModLoaded((String)"CompactMachines");
    }

    public static boolean enableThaumGogglesModule() {
        boolean defaultval = ModCompatibility.isThaumCraftLoaded();
        return Config.getConfig().get("Special Modules", "Thaumcraft Goggles Module", defaultval).getBoolean(defaultval);
    }

    public static double getIC2Ratio() {
        return Config.getConfig().get("general", "Energy per IC2 EU", 0.4).getDouble(0.4);
    }

    public static double getRFRatio() {
        return Config.getConfig().get("general", "Energy per RF", 0.1).getDouble(0.1);
    }

    public static double getAE2Ratio() {
        return Config.getConfig().get("general", "Energy per AE", 0.2).getDouble(0.2);
    }

    public static void registerModSpecificModules() {
        ModCompatibility.getIC2Ratio();
        ModCompatibility.getRFRatio();
        if (ModCompatibility.isThaumCraftLoaded() && ModCompatibility.enableThaumGogglesModule()) {
            ModuleManager.addModule(new ThaumGogglesModule(Collections.singletonList(MPSItems.powerArmorHead())));
        }
    }
}

